/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.api.solver.event.EventProducerId;
import ai.timefold.solver.core.impl.solver.BestSolutionContainingProblemChanges;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class BestSolutionHolder<Solution_> {
    private final AtomicReference<BigInteger> lastProcessedVersion = new AtomicReference<BigInteger>(BigInteger.valueOf(-1L));
    private volatile SortedMap<BigInteger, List<CompletableFuture<Void>>> problemChangesPerVersionMap = BestSolutionHolder.createNewProblemChangesMap();
    private volatile @Nullable VersionedBestSolution<Solution_> versionedBestSolution = null;
    private volatile BigInteger currentVersion = BigInteger.ZERO;

    BestSolutionHolder() {
    }

    private static SortedMap<BigInteger, List<CompletableFuture<Void>>> createNewProblemChangesMap() {
        return BestSolutionHolder.createNewProblemChangesMap(Collections.emptySortedMap());
    }

    private static SortedMap<BigInteger, List<CompletableFuture<Void>>> createNewProblemChangesMap(SortedMap<BigInteger, List<CompletableFuture<Void>>> map) {
        return new TreeMap<BigInteger, List<CompletableFuture<Void>>>(map);
    }

    synchronized boolean isEmpty() {
        return this.versionedBestSolution == null;
    }

    @Nullable BestSolutionContainingProblemChanges<Solution_> take() {
        VersionedBestSolution<Solution_> latestVersionedBestSolution = this.resetVersionedBestSolution();
        if (latestVersionedBestSolution == null) {
            return null;
        }
        BigInteger bestSolutionVersion = latestVersionedBestSolution.version();
        BigInteger latestProcessedVersion = this.lastProcessedVersion.getAndUpdate(bestSolutionVersion::max);
        if (latestProcessedVersion.compareTo(bestSolutionVersion) > 0) {
            return null;
        }
        BigInteger boundaryVersion = bestSolutionVersion.add(BigInteger.ONE);
        SortedMap<BigInteger, List<CompletableFuture<Void>>> oldProblemChangesPerVersion = this.replaceMapSynchronized(map -> BestSolutionHolder.createNewProblemChangesMap(map.tailMap(boundaryVersion)));
        List<CompletableFuture<Void>> containedProblemChanges = oldProblemChangesPerVersion.headMap(boundaryVersion).values().stream().flatMap(Collection::stream).toList();
        return new BestSolutionContainingProblemChanges<Solution_>(latestVersionedBestSolution.bestSolution(), latestVersionedBestSolution.producerId(), containedProblemChanges);
    }

    private synchronized @Nullable VersionedBestSolution<Solution_> resetVersionedBestSolution() {
        VersionedBestSolution<Solution_> oldVersionedBestSolution = this.versionedBestSolution;
        this.versionedBestSolution = null;
        return oldVersionedBestSolution;
    }

    private synchronized SortedMap<BigInteger, List<CompletableFuture<Void>>> replaceMapSynchronized(UnaryOperator<SortedMap<BigInteger, List<CompletableFuture<Void>>>> replaceFunction) {
        SortedMap<BigInteger, List<CompletableFuture<Void>>> oldMap = this.problemChangesPerVersionMap;
        this.problemChangesPerVersionMap = (SortedMap)replaceFunction.apply(oldMap);
        return oldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(Solution_ bestSolution, EventProducerId producerId, BooleanSupplier isEveryProblemChangeProcessed) {
        if (isEveryProblemChangeProcessed.getAsBoolean()) {
            BestSolutionHolder bestSolutionHolder = this;
            synchronized (bestSolutionHolder) {
                this.versionedBestSolution = new VersionedBestSolution<Solution_>(bestSolution, producerId, this.currentVersion);
                this.currentVersion = this.currentVersion.add(BigInteger.ONE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull CompletableFuture<Void> addProblemChange(Solver<Solution_> solver, List<ProblemChange<Solution_>> problemChangeList) {
        CompletableFuture<Void> futureProblemChange = new CompletableFuture<Void>();
        BestSolutionHolder bestSolutionHolder = this;
        synchronized (bestSolutionHolder) {
            List futureProblemChangeList = this.problemChangesPerVersionMap.computeIfAbsent(this.currentVersion, version -> new ArrayList());
            futureProblemChangeList.add(futureProblemChange);
            solver.addProblemChanges(problemChangeList);
        }
        return futureProblemChange;
    }

    void cancelPendingChanges() {
        this.replaceMapSynchronized(map -> BestSolutionHolder.createNewProblemChangesMap()).values().stream().flatMap(Collection::stream).forEach(pendingProblemChange -> pendingProblemChange.cancel(false));
    }

    private record VersionedBestSolution<Solution_>(Solution_ bestSolution, EventProducerId producerId, BigInteger version) {
    }
}

