/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import ai.timefold.solver.core.api.score.stream.quad.QuadJoiner;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.jspecify.annotations.NonNull;

public interface InnerTriConstraintStream<A, B, C>
extends TriConstraintStream<A, B, C> {
    public static <A, B, C> QuadFunction<A, B, C, Score<?>, DefaultConstraintJustification> createDefaultJustificationMapping() {
        return (a, b, c, score) -> DefaultConstraintJustification.of(score, a, b, c);
    }

    public static <A, B, C> TriFunction<A, B, C, Collection<?>> createDefaultIndictedObjectsMapping() {
        return (xva$0, xva$1, xva$2) -> Arrays.asList(xva$0, xva$1, xva$2);
    }

    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    @Override
    default public <D> @NonNull QuadConstraintStream<A, B, C, D> join(@NonNull Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.join(this.getConstraintFactory().forEach(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.join(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.join(this.getConstraintFactory().from(otherClass), joiners);
        };
    }

    @Override
    default public <D> @NonNull TriConstraintStream<A, B, C> ifExists(@NonNull Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifExists(this.getConstraintFactory().forEach(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public <D> @NonNull TriConstraintStream<A, B, C> ifExistsIncludingUnassigned(@NonNull Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public <D> @NonNull TriConstraintStream<A, B, C> ifNotExists(@NonNull Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifNotExists(this.getConstraintFactory().forEach(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifNotExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public <D> @NonNull TriConstraintStream<A, B, C> ifNotExistsIncludingUnassigned(@NonNull Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifNotExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifNotExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public @NonNull TriConstraintStream<A, B, C> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy(ConstantLambdaUtils.triPickFirst(), ConstantLambdaUtils.triPickSecond(), ConstantLambdaUtils.triPickThird());
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> penalize(@NonNull Score_ constraintWeight, @NonNull ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> penalizeLong(@NonNull Score_ constraintWeight, @NonNull ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> penalizeBigDecimal(@NonNull Score_ constraintWeight, @NonNull TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> reward(@NonNull Score_ constraintWeight, @NonNull ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> rewardLong(@NonNull Score_ constraintWeight, @NonNull ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> rewardBigDecimal(@NonNull Score_ constraintWeight, @NonNull TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> impact(@NonNull Score_ constraintWeight, @NonNull ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> impactLong(@NonNull Score_ constraintWeight, @NonNull ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull TriConstraintBuilder<A, B, C, Score_> impactBigDecimal(@NonNull Score_ constraintWeight, @NonNull TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> impactConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> impactConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> impactConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, ToIntTriFunction<A, B, C> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, ToLongTriFunction<A, B, C> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, TriFunction<A, B, C, BigDecimal> var2, ScoreImpactType var3);

    @Override
    default public @NonNull Constraint penalize(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint penalize(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint penalizeConfigurable(@NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint penalizeConfigurable(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint reward(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint reward(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint rewardConfigurable(@NonNull String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint rewardConfigurable(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint impact(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint impact(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

