/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.buildin.bendablelong.BendableLongScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.BendableLongScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.util.Arrays;
import java.util.Map;

public final class BendableLongScoreInliner
extends AbstractScoreInliner<BendableLongScore> {
    final long[] hardScores;
    final long[] softScores;

    BendableLongScoreInliner(Map<Constraint, BendableLongScore> constraintWeightMap, ConstraintMatchPolicy constraintMatchPolicy, int hardLevelsSize, int softLevelsSize) {
        super(constraintWeightMap, constraintMatchPolicy);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter<BendableLongScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        Integer singleLevel = null;
        BendableLongScore constraintWeight = (BendableLongScore)this.constraintWeightMap.get(constraint);
        for (int i = 0; i < constraintWeight.levelsSize(); ++i) {
            if (constraintWeight.hardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.hardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.hardLevelsSize();
            BendableLongScoreContext context = new BendableLongScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.hardOrSoftScore(singleLevel));
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, (ctx, impact, constraintMatchSupplier) -> ctx.changeHardScoreBy(impact, constraintMatchSupplier));
            }
            return WeightedScoreImpacter.of(context, (ctx, impact, constraintMatchSupplier) -> ctx.changeSoftScoreBy(impact, constraintMatchSupplier));
        }
        BendableLongScoreContext context = new BendableLongScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length);
        return WeightedScoreImpacter.of(context, (ctx, impact, constraintMatchSupplier) -> ctx.changeScoreBy(impact, constraintMatchSupplier));
    }

    @Override
    public BendableLongScore extractScore() {
        return BendableLongScore.of(Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableLongScore.class.getSimpleName() + " inliner";
    }
}

