/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.ChangeMove;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.CompositeMove;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.ListAssignMove;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.ListChangeMove;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.ListSwapMove;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.ListUnassignMove;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.SwapMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Moves {
    public static <Solution_> Move<Solution_> compose(List<Move<Solution_>> moves) {
        return Moves.compose(moves.toArray(new Move[0]));
    }

    @SafeVarargs
    public static <Solution_> Move<Solution_> compose(Move<Solution_> ... moves) {
        return CompositeMove.buildMove((Move[])moves);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> change(Entity_ entity, @Nullable Value_ value, PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return new ChangeMove<Solution_, Entity_, Value_>(variableMetaModel, entity, value);
    }

    public static <Solution_, Entity_> Move<Solution_> swap(Entity_ leftEntity, Entity_ rightEntity, PlanningVariableMetaModel<Solution_, Entity_, Object> variableMetaModel) {
        return new SwapMove<Solution_, Entity_>(Collections.singletonList(variableMetaModel), leftEntity, rightEntity);
    }

    @SafeVarargs
    public static <Solution_, Entity_> Move<Solution_> swap(Entity_ leftEntity, Entity_ rightEntity, PlanningVariableMetaModel<Solution_, Entity_, Object> ... variableMetaModels) {
        return new SwapMove<Solution_, Entity_>(Arrays.asList(variableMetaModels), leftEntity, rightEntity);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> assign(Value_ value, PositionInList targetPosition, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return Moves.assign(value, targetPosition.entity(), targetPosition.index(), variableMetaModel);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> assign(Value_ value, Entity_ entity, int index, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return new ListAssignMove<Solution_, Entity_, Value_>(variableMetaModel, value, entity, index);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> unassign(PositionInList targetPosition, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return Moves.unassign(targetPosition.entity(), targetPosition.index(), variableMetaModel);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> unassign(Entity_ entity, int index, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return new ListUnassignMove<Solution_, Entity_, Value_>(variableMetaModel, entity, index);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> change(PositionInList left, PositionInList right, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return Moves.change(left.entity(), left.index(), right.entity(), right.index(), variableMetaModel);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> change(Entity_ leftEntity, int leftIndex, Entity_ rightEntity, int rightIndex, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return new ListChangeMove<Solution_, Entity_, Value_>(variableMetaModel, leftEntity, leftIndex, rightEntity, rightIndex);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> swap(PositionInList left, PositionInList right, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return Moves.swap(left.entity(), left.index(), right.entity(), right.index(), variableMetaModel);
    }

    public static <Solution_, Entity_, Value_> Move<Solution_> swap(Entity_ leftEntity, int leftIndex, Entity_ rightEntity, int rightIndex, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return new ListSwapMove<Solution_, Entity_, Value_>(variableMetaModel, leftEntity, leftIndex, rightEntity, rightIndex);
    }

    private Moves() {
    }
}

