/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.simulatedannealing;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;

public class SimulatedAnnealingAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected Score startingTemperature;
    protected int levelsLength = -1;
    protected double[] startingTemperatureLevels;
    protected double[] temperatureLevels;
    protected double temperatureMinimum = 1.0E-100;

    public void setStartingTemperature(Score startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        for (double startingTemperatureLevel : this.startingTemperature.toLevelDoubles()) {
            if (!(startingTemperatureLevel < 0.0)) continue;
            throw new IllegalArgumentException("The startingTemperature (" + String.valueOf(this.startingTemperature) + ") cannot have negative level (" + startingTemperatureLevel + ").");
        }
        this.startingTemperatureLevels = this.startingTemperature.toLevelDoubles();
        this.temperatureLevels = this.startingTemperatureLevels;
        this.levelsLength = this.startingTemperatureLevels.length;
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.startingTemperatureLevels = null;
        this.temperatureLevels = null;
        this.levelsLength = -1;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        AbstractPhaseScope phaseScope = ((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope();
        Object lastStepScore = ((LocalSearchPhaseScope)phaseScope).getLastCompletedStepScope().getScore().raw();
        Object moveScore = moveScope.getScore().raw();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return true;
        }
        Object moveScoreDifference = lastStepScore.subtract(moveScore);
        double[] moveScoreDifferenceLevels = moveScoreDifference.toLevelDoubles();
        double acceptChance = 1.0;
        for (int i = 0; i < this.levelsLength; ++i) {
            double moveScoreDifferenceLevel = moveScoreDifferenceLevels[i];
            double temperatureLevel = this.temperatureLevels[i];
            double acceptChanceLevel = moveScoreDifferenceLevel <= 0.0 ? 1.0 : Math.exp(-moveScoreDifferenceLevel / temperatureLevel);
            acceptChance *= acceptChanceLevel;
        }
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        double timeGradient = stepScope.getTimeGradient();
        double reverseTimeGradient = 1.0 - timeGradient;
        this.temperatureLevels = new double[this.levelsLength];
        for (int i = 0; i < this.levelsLength; ++i) {
            this.temperatureLevels[i] = this.startingTemperatureLevels[i] * reverseTimeGradient;
            if (!(this.temperatureLevels[i] < this.temperatureMinimum)) continue;
            this.temperatureLevels[i] = this.temperatureMinimum;
        }
    }
}

