/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.ValueRangeRecorderId;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementDestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.Objects;

public final class DestinationSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, DestinationSelectorConfig> {
    public static <Solution_> DestinationSelectorFactory<Solution_> create(DestinationSelectorConfig destinationSelectorConfig) {
        return new DestinationSelectorFactory<Solution_>(destinationSelectorConfig);
    }

    private DestinationSelectorFactory(DestinationSelectorConfig destinationSelectorConfig) {
        super(destinationSelectorConfig);
    }

    public DestinationSelector<Solution_> buildDestinationSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        return this.buildDestinationSelector(configPolicy, minimumCacheType, randomSelection, null);
    }

    public DestinationSelector<Solution_> buildDestinationSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection, String entityValueRangeRecorderId) {
        boolean hasSorter;
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelectorConfig entitySelectorConfig = Objects.requireNonNull(((DestinationSelectorConfig)this.config).getEntitySelectorConfig()).copyConfig();
        boolean hasSortManner = configPolicy.getEntitySorterManner() != null && configPolicy.getEntitySorterManner() != EntitySorterManner.NONE;
        EntityDescriptor<Solution_> entityDescriptor = this.deduceEntityDescriptor(configPolicy, entitySelectorConfig.getEntityClass());
        boolean bl = hasSorter = entityDescriptor.getDescendingSorter() != null;
        if (hasSortManner && hasSorter && entitySelectorConfig.getSorterManner() == null) {
            if (entityValueRangeRecorderId == null) {
                entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
            } else {
                entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
            }
            entitySelectorConfig.setSelectionOrder(SelectionOrder.SORTED);
            entitySelectorConfig.setSorterManner(configPolicy.getEntitySorterManner());
        }
        EntitySelector entitySelector = EntitySelectorFactory.create(entitySelectorConfig).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder, new ValueRangeRecorderId(entityValueRangeRecorderId, false));
        IterableValueSelector<Solution_> valueSelector = this.buildIterableValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder, entityValueRangeRecorderId);
        ElementDestinationSelector baseDestinationSelector = new ElementDestinationSelector(entitySelector, valueSelector, selectionOrder.toRandomSelectionBoolean());
        return this.applyNearbySelection(configPolicy, minimumCacheType, selectionOrder, baseDestinationSelector, entityValueRangeRecorderId != null);
    }

    private IterableValueSelector<Solution_> buildIterableValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, String entityValueRangeRecorderId) {
        ValueSelector valueSelector = ValueSelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getValueSelectorConfig())).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), ValueSelectorFactory.ListValueFilteringType.ACCEPT_ASSIGNED, entityValueRangeRecorderId, false);
        return (IterableValueSelector)valueSelector;
    }

    private DestinationSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder selectionOrder, ElementDestinationSelector<Solution_> destinationSelector, boolean enableEntityValueRange) {
        NearbySelectionConfig nearbySelectionConfig = ((DestinationSelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig == null) {
            return destinationSelector;
        }
        if (enableEntityValueRange) {
            EntitySelector entitySelector = EntitySelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getEntitySelectorConfig())).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
            ValueSelector valueSelector = ValueSelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getValueSelectorConfig())).buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), ValueSelectorFactory.ListValueFilteringType.ACCEPT_ASSIGNED, null, false);
            ElementDestinationSelector updatedDestinationSelector = new ElementDestinationSelector(entitySelector, (IterableValueSelector)valueSelector, selectionOrder.toRandomSelectionBoolean());
            return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((DestinationSelectorConfig)this.config, configPolicy, minimumCacheType, selectionOrder, updatedDestinationSelector);
        }
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((DestinationSelectorConfig)this.config, configPolicy, minimumCacheType, selectionOrder, destinationSelector);
    }
}

