/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity;

import ai.timefold.solver.core.api.domain.common.ComparatorFactory;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.ValueRangeRecorderId;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.FromSolutionEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.CachingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntityByEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntityByValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.ProbabilityEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.SelectedCountLimitEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.ShufflingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.SortingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntitySelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, EntitySelectorConfig> {
    public static <Solution_> EntitySelectorFactory<Solution_> create(EntitySelectorConfig entitySelectorConfig) {
        return new EntitySelectorFactory<Solution_>(entitySelectorConfig);
    }

    public EntitySelectorFactory(EntitySelectorConfig entitySelectorConfig) {
        super(entitySelectorConfig);
    }

    public EntityDescriptor<Solution_> extractEntityDescriptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        Class<?> entityClass = ((EntitySelectorConfig)this.config).getEntityClass();
        String mimicSelectorRef = ((EntitySelectorConfig)this.config).getMimicSelectorRef();
        if (entityClass != null) {
            SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
            EntityDescriptor<Solution_> entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(entityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (%s) has an entityClass (%s) that is not a known planning entity.\nCheck your solver configuration. If that class (%s) is not in the entityClassSet (%s), check your @%s implementation's annotated methods too.".formatted(this.config, entityClass, entityClass.getSimpleName(), solutionDescriptor.getEntityClassSet(), PlanningSolution.class.getSimpleName()));
            }
            return entityDescriptor;
        }
        if (mimicSelectorRef != null) {
            return configPolicy.getEntityMimicRecorder(mimicSelectorRef).getEntityDescriptor();
        }
        return null;
    }

    public EntitySelector<Solution_> buildEntitySelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        return this.buildEntitySelector(configPolicy, minimumCacheType, inheritedSelectionOrder, null);
    }

    public EntitySelector<Solution_> buildEntitySelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, ValueRangeRecorderId valueRangeRecorderId) {
        if (((EntitySelectorConfig)this.config).getMimicSelectorRef() != null) {
            return this.buildMimicReplaying(configPolicy);
        }
        EntityDescriptor<Solution_> entityDescriptor = this.deduceEntityDescriptor(configPolicy, ((EntitySelectorConfig)this.config).getEntityClass());
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((EntitySelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((EntitySelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        NearbySelectionConfig nearbySelectionConfig = ((EntitySelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig != null) {
            nearbySelectionConfig.validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder, valueRangeRecorderId != null && valueRangeRecorderId.recorderId() != null);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        boolean baseRandomSelection = this.determineBaseRandomSelection(entityDescriptor, resolvedCacheType, resolvedSelectionOrder);
        SelectionCacheType baseSelectionCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        EntitySelector<Solution_> entitySelector = this.buildBaseEntitySelector(entityDescriptor, baseSelectionCacheType, baseRandomSelection);
        ClassInstanceCache instanceCache = configPolicy.getClassInstanceCache();
        entitySelector = nearbySelectionConfig != null ? this.applyNearbySelection(configPolicy, nearbySelectionConfig, minimumCacheType, resolvedSelectionOrder, entitySelector) : this.applyEntityValueRangeFiltering(configPolicy, entitySelector, valueRangeRecorderId, minimumCacheType, inheritedSelectionOrder, baseRandomSelection);
        entitySelector = this.applyFiltering(entitySelector, instanceCache);
        entitySelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, entitySelector, instanceCache);
        entitySelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, entitySelector, instanceCache);
        entitySelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applySelectedLimit(resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyMimicRecording(configPolicy, entitySelector);
        return entitySelector;
    }

    protected EntitySelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        boolean anyConfigurationParameterDefined = Stream.of(new Object[]{((EntitySelectorConfig)this.config).getId(), ((EntitySelectorConfig)this.config).getEntityClass(), ((EntitySelectorConfig)this.config).getCacheType(), ((EntitySelectorConfig)this.config).getSelectionOrder(), ((EntitySelectorConfig)this.config).getNearbySelectionConfig(), ((EntitySelectorConfig)this.config).getFilterClass(), ((EntitySelectorConfig)this.config).getSorterManner(), EntitySelectorFactory.determineComparatorClass((EntitySelectorConfig)this.config), EntitySelectorFactory.determineComparatorFactoryClass((EntitySelectorConfig)this.config), ((EntitySelectorConfig)this.config).getSorterOrder(), ((EntitySelectorConfig)this.config).getSorterClass(), ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass(), ((EntitySelectorConfig)this.config).getSelectedCountLimit()}).anyMatch(Objects::nonNull);
        if (anyConfigurationParameterDefined) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with mimicSelectorRef (%s) has another property that is not null.".formatted(this.config, ((EntitySelectorConfig)this.config).getMimicSelectorRef()));
        }
        return this.buildMimicReplaying(configPolicy, ((EntitySelectorConfig)this.config).getMimicSelectorRef());
    }

    private MimicReplayingEntitySelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy, String id) {
        EntityMimicRecorder<Solution_> entityMimicRecorder = configPolicy.getEntityMimicRecorder(id);
        if (entityMimicRecorder == null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has a mimicSelectorRef (%s) for which no entitySelector with that id exists (in its solver phase).".formatted(this.config, ((EntitySelectorConfig)this.config).getMimicSelectorRef()));
        }
        return new MimicReplayingEntitySelector<Solution_>(entityMimicRecorder);
    }

    protected boolean determineBaseRandomSelection(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        return switch (resolvedSelectionOrder) {
            case SelectionOrder.ORIGINAL, SelectionOrder.SORTED, SelectionOrder.SHUFFLED, SelectionOrder.PROBABILISTIC -> false;
            case SelectionOrder.RANDOM -> {
                if (resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && !this.hasFiltering(entityDescriptor)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("The selectionOrder (%s) is not implemented.".formatted(new Object[]{resolvedSelectionOrder}));
        };
    }

    protected boolean isBaseInherentlyCached() {
        return true;
    }

    private static String determineComparatorPropertyName(EntitySelectorConfig entitySelectorConfig) {
        Class<? extends Comparator> sorterComparatorClass = entitySelectorConfig.getSorterComparatorClass();
        Class<? extends Comparator> comparatorClass = entitySelectorConfig.getComparatorClass();
        if (sorterComparatorClass != null && comparatorClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) cannot have a %s (%s) and %s (%s) at the same time.".formatted(entitySelectorConfig, "sorterComparatorClass", sorterComparatorClass, "comparatorClass", comparatorClass));
        }
        return sorterComparatorClass != null ? "sorterComparatorClass" : "comparatorClass";
    }

    private static Class<? extends Comparator> determineComparatorClass(EntitySelectorConfig entitySelectorConfig) {
        String propertyName = EntitySelectorFactory.determineComparatorPropertyName(entitySelectorConfig);
        if (propertyName.equals("sorterComparatorClass")) {
            return entitySelectorConfig.getSorterComparatorClass();
        }
        return entitySelectorConfig.getComparatorClass();
    }

    private static String determineComparatorFactoryPropertyName(EntitySelectorConfig entitySelectorConfig) {
        Class<? extends SelectionSorterWeightFactory> weightFactoryClass = entitySelectorConfig.getSorterWeightFactoryClass();
        Class<? extends ComparatorFactory> comparatorFactoryClass = entitySelectorConfig.getComparatorFactoryClass();
        if (weightFactoryClass != null && comparatorFactoryClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) cannot have a %s (%s) and %s (%s) at the same time.".formatted(entitySelectorConfig, "sorterWeightFactoryClass", weightFactoryClass, "comparatorFactoryClass", comparatorFactoryClass));
        }
        return weightFactoryClass != null ? "sorterWeightFactoryClass" : "comparatorFactoryClass";
    }

    private static Class<? extends ComparatorFactory> determineComparatorFactoryClass(EntitySelectorConfig entitySelectorConfig) {
        String propertyName = EntitySelectorFactory.determineComparatorFactoryPropertyName(entitySelectorConfig);
        if (propertyName.equals("sorterWeightFactoryClass")) {
            return entitySelectorConfig.getSorterWeightFactoryClass();
        }
        return entitySelectorConfig.getComparatorFactoryClass();
    }

    private EntitySelector<Solution_> buildBaseEntitySelector(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (%s) is not supported here. Please use %s instead.".formatted(new Object[]{minimumCacheType, SelectionCacheType.PHASE}));
        }
        return new FromSolutionEntitySelector<Solution_>(entityDescriptor, minimumCacheType, randomSelection);
    }

    private boolean hasFiltering(EntityDescriptor<Solution_> entityDescriptor) {
        return ((EntitySelectorConfig)this.config).getFilterClass() != null || entityDescriptor.hasEffectiveMovableEntityFilter();
    }

    private EntitySelector<Solution_> applyEntityValueRangeFiltering(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, ValueRangeRecorderId valueRangeRecorderId, SelectionCacheType minimumCacheType, SelectionOrder selectionOrder, boolean randomSelection) {
        if (valueRangeRecorderId == null || valueRangeRecorderId.recorderId() == null) {
            return entitySelector;
        }
        if (valueRangeRecorderId.basicVariable()) {
            MimicReplayingEntitySelector<Solution_> replayingEntitySelector = this.buildMimicReplaying(configPolicy, valueRangeRecorderId.recorderId());
            return new FilteringEntityByEntitySelector<Solution_>(entitySelector, replayingEntitySelector, randomSelection);
        }
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig().withMimicSelectorRef(valueRangeRecorderId.recorderId());
        IterableValueSelector replayingValueSelector = (IterableValueSelector)ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder);
        return new FilteringEntityByValueSelector<Solution_>(entitySelector, replayingValueSelector, randomSelection);
    }

    private EntitySelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, NearbySelectionConfig nearbySelectionConfig, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((EntitySelectorConfig)this.config, configPolicy, nearbySelectionConfig, minimumCacheType, resolvedSelectionOrder, entitySelector);
    }

    private EntitySelector<Solution_> applyFiltering(EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        EntityDescriptor entityDescriptor = entitySelector.getEntityDescriptor();
        if (this.hasFiltering(entityDescriptor)) {
            Class<? extends SelectionFilter> filterClass = ((EntitySelectorConfig)this.config).getFilterClass();
            ArrayList filterList = new ArrayList(filterClass == null ? 1 : 2);
            if (filterClass != null) {
                SelectionFilter selectionFilter = instanceCache.newInstance(this.config, "filterClass", filterClass);
                filterList.add(selectionFilter);
            }
            if (entityDescriptor.hasEffectiveMovableEntityFilter()) {
                filterList.add((scoreDirector, selection) -> entityDescriptor.getEffectiveMovableEntityFilter().test(scoreDirector.getWorkingSolution(), selection));
            }
            entitySelector = FilteringEntitySelector.of(entitySelector, SelectionFilter.compose(filterList));
        }
        return entitySelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        EntitySorterManner sorterManner = ((EntitySelectorConfig)this.config).getSorterManner();
        Class<Comparator> comparatorClass = EntitySelectorFactory.determineComparatorClass((EntitySelectorConfig)this.config);
        String comparatorPropertyName = EntitySelectorFactory.determineComparatorPropertyName((EntitySelectorConfig)this.config);
        String comparatorFactoryPropertyName = EntitySelectorFactory.determineComparatorFactoryPropertyName((EntitySelectorConfig)this.config);
        Class<ComparatorFactory> comparatorFactoryClass = EntitySelectorFactory.determineComparatorFactoryClass((EntitySelectorConfig)this.config);
        SelectionSorterOrder sorterOrder = ((EntitySelectorConfig)this.config).getSorterOrder();
        Class<? extends SelectionSorter> sorterClass = ((EntitySelectorConfig)this.config).getSorterClass();
        if ((sorterManner != null || comparatorClass != null || comparatorFactoryClass != null || sorterOrder != null || sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with sorterManner (%s) and %s (%s) and %s (%s) and sorterOrder (%s) and sorterClass (%s) has a resolvedSelectionOrder (%s) that is not %s.".formatted(new Object[]{this.config, sorterManner, comparatorPropertyName, comparatorClass, comparatorFactoryPropertyName, comparatorFactoryClass, sorterOrder, sorterClass, resolvedSelectionOrder, SelectionOrder.SORTED}));
        }
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, comparatorPropertyName, EntitySelectorFactory::determineComparatorClass);
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, comparatorFactoryPropertyName, EntitySelectorFactory::determineComparatorFactoryClass);
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, "sorterClass", EntitySelectorConfig::getSorterClass);
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, "sorterOrder", EntitySelectorConfig::getSorterOrder);
        EntitySelectorFactory.assertNotSorterClassAnd((EntitySelectorConfig)this.config, comparatorPropertyName, EntitySelectorFactory::determineComparatorClass);
        EntitySelectorFactory.assertNotSorterClassAnd((EntitySelectorConfig)this.config, comparatorFactoryPropertyName, EntitySelectorFactory::determineComparatorFactoryClass);
        EntitySelectorFactory.assertNotSorterClassAnd((EntitySelectorConfig)this.config, "sorterOrder", EntitySelectorConfig::getSorterOrder);
        if (comparatorClass != null && comparatorFactoryClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has both a %s (%s) and a %s (%s).".formatted(this.config, comparatorPropertyName, comparatorClass, comparatorFactoryPropertyName, comparatorFactoryClass));
        }
    }

    private static void assertNotSorterMannerAnd(EntitySelectorConfig config, String propertyName, Function<EntitySelectorConfig, Object> propertyAccessor) {
        EntitySorterManner sorterManner = config.getSorterManner();
        Object property = propertyAccessor.apply(config);
        if (sorterManner != null && property != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has both a sorterManner (%s) and a %s (%s).".formatted(new Object[]{config, sorterManner, propertyName, property}));
        }
    }

    private static void assertNotSorterClassAnd(EntitySelectorConfig config, String propertyName, Function<EntitySelectorConfig, Object> propertyAccessor) {
        Class<? extends SelectionSorter> sorterClass = config.getSorterClass();
        Object property = propertyAccessor.apply(config);
        if (sorterClass != null && property != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with sorterClass (%s) has a non-null %s (%s).".formatted(config, sorterClass, propertyName, property));
        }
    }

    protected EntitySelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            EntitySorterManner sorterManner = ((EntitySelectorConfig)this.config).getSorterManner();
            Class<Comparator> comparatorClass = EntitySelectorFactory.determineComparatorClass((EntitySelectorConfig)this.config);
            Class<ComparatorFactory> comparatorFactoryClass = EntitySelectorFactory.determineComparatorFactoryClass((EntitySelectorConfig)this.config);
            if (sorterManner != null) {
                EntityDescriptor<Solution_> entityDescriptor = entitySelector.getEntityDescriptor();
                if (!EntitySelectorConfig.hasSorter(sorterManner, entityDescriptor)) {
                    return entitySelector;
                }
                sorter = EntitySelectorConfig.determineSorter(sorterManner, entityDescriptor);
            } else if (comparatorClass != null) {
                Comparator sorterComparator = instanceCache.newInstance(this.config, EntitySelectorFactory.determineComparatorPropertyName((EntitySelectorConfig)this.config), comparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(((EntitySelectorConfig)this.config).getSorterOrder()));
            } else if (comparatorFactoryClass != null) {
                ComparatorFactory comparatorFactory = instanceCache.newInstance(this.config, EntitySelectorFactory.determineComparatorFactoryPropertyName((EntitySelectorConfig)this.config), comparatorFactoryClass);
                sorter = new ComparatorFactorySelectionSorter(comparatorFactory, SelectionSorterOrder.resolve(((EntitySelectorConfig)this.config).getSorterOrder()));
            } else if (((EntitySelectorConfig)this.config).getSorterClass() != null) {
                sorter = instanceCache.newInstance(this.config, "sorterClass", ((EntitySelectorConfig)this.config).getSorterClass());
            } else {
                throw new IllegalArgumentException("The entitySelectorConfig (%s) with resolvedSelectionOrder (%s) needs a sorterManner (%s) or a %s (%s) or a %s (%s) or a sorterClass (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, sorterManner, EntitySelectorFactory.determineComparatorPropertyName((EntitySelectorConfig)this.config), comparatorClass, EntitySelectorFactory.determineComparatorFactoryPropertyName((EntitySelectorConfig)this.config), comparatorFactoryClass, ((EntitySelectorConfig)this.config).getSorterClass()}));
            }
            entitySelector = new SortingEntitySelector<Solution_>(entitySelector, resolvedCacheType, sorter);
        }
        return entitySelector;
    }

    protected void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + String.valueOf(this.config) + ") with probabilityWeightFactoryClass (" + String.valueOf(((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass()) + ") has a resolvedSelectionOrder (" + String.valueOf((Object)resolvedSelectionOrder) + ") that is not " + String.valueOf((Object)SelectionOrder.PROBABILISTIC) + ".");
        }
    }

    protected EntitySelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() == null) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + String.valueOf(this.config) + ") with resolvedSelectionOrder (" + String.valueOf((Object)resolvedSelectionOrder) + ") needs a probabilityWeightFactoryClass (" + String.valueOf(((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass()) + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = instanceCache.newInstance(this.config, "probabilityWeightFactoryClass", ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass());
            entitySelector = new ProbabilityEntitySelector<Solution_>(entitySelector, resolvedCacheType, probabilityWeightFactory);
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            entitySelector = new ShufflingEntitySelector<Solution_>(entitySelector, resolvedCacheType);
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(entitySelector.getCacheType()) > 0) {
            entitySelector = new CachingEntitySelector<Solution_>(entitySelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return entitySelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((EntitySelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + String.valueOf(this.config) + ") with selectedCountLimit (" + ((EntitySelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + String.valueOf((Object)minimumCacheType) + ") that is higher than " + String.valueOf((Object)SelectionCacheType.JUST_IN_TIME) + ".");
        }
    }

    private EntitySelector<Solution_> applySelectedLimit(SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (((EntitySelectorConfig)this.config).getSelectedCountLimit() != null) {
            entitySelector = new SelectedCountLimitEntitySelector<Solution_>(entitySelector, resolvedSelectionOrder.toRandomSelectionBoolean(), ((EntitySelectorConfig)this.config).getSelectedCountLimit());
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector) {
        String id = ((EntitySelectorConfig)this.config).getId();
        if (id != null) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("The entitySelectorConfig (%s) has an empty id (%s).".formatted(this.config, id));
            }
            MimicRecordingEntitySelector<Solution_> mimicRecordingEntitySelector = new MimicRecordingEntitySelector<Solution_>(entitySelector);
            configPolicy.addEntityMimicRecorder(id, mimicRecordingEntitySelector);
            entitySelector = mimicRecordingEntitySelector;
        }
        return entitySelector;
    }
}

