/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.move;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class CompositeMove<Solution_>
extends AbstractMove<Solution_> {
    private final Move<Solution_>[] moves;

    @SafeVarargs
    public static <Solution_, Move_ extends Move<Solution_>> Move<Solution_> buildMove(Move_ ... moves) {
        return switch (moves.length) {
            case 0 -> NoChangeMove.getInstance();
            case 1 -> moves[0];
            default -> new CompositeMove<Solution_>((Move<Solution_>[])moves);
        };
    }

    public static <Solution_, Move_ extends Move<Solution_>> Move<Solution_> buildMove(List<Move_> moveList) {
        return CompositeMove.buildMove((Move[])moveList.toArray(new Move[0]));
    }

    @SafeVarargs
    CompositeMove(Move<Solution_> ... moves) {
        this.moves = moves;
    }

    public Move<Solution_>[] getMoves() {
        return this.moves;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        for (Move<Solution_> move : this.moves) {
            if (!move.isMoveDoable(scoreDirector)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        for (Move<Solution_> move : this.moves) {
            if (!move.isMoveDoable(scoreDirector)) continue;
            move.doMoveOnly(scoreDirector);
        }
    }

    @Override
    public CompositeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        Move[] rebasedMoves = new Move[this.moves.length];
        for (int i = 0; i < this.moves.length; ++i) {
            rebasedMoves[i] = this.moves[i].rebase(destinationScoreDirector);
        }
        return new CompositeMove<Solution_>(rebasedMoves);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + Arrays.stream(this.moves).map(Move::getSimpleMoveTypeDescription).sorted().map(childMoveTypeDescription -> "* " + childMoveTypeDescription).collect(Collectors.joining(",", "(", ")"));
    }

    @Override
    public Collection<?> getPlanningEntities() {
        Set entities = CollectionUtils.newLinkedHashSet(this.moves.length * 2);
        for (Move<Solution_> move : this.moves) {
            entities.addAll(move.getPlanningEntities());
        }
        return entities;
    }

    @Override
    public Collection<?> getPlanningValues() {
        Set values = CollectionUtils.newLinkedHashSet(this.moves.length * 2);
        for (Move<Solution_> move : this.moves) {
            values.addAll(move.getPlanningValues());
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof CompositeMove)) return false;
        CompositeMove otherCompositeMove = (CompositeMove)other;
        if (!Arrays.equals(this.moves, otherCompositeMove.moves)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.moves);
    }

    public String toString() {
        return Arrays.toString(this.moves);
    }
}

