/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.impl.domain.variable.BasicVariableChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.InnerBasicVariableListener;
import ai.timefold.solver.core.impl.domain.variable.InnerVariableListener;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;

public class SingletonInverseVariableListener<Solution_>
implements InnerBasicVariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;

    public SingletonInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(InnerScoreDirector<Solution_, ?> scoreDirector) {
        InnerVariableListener.forEachEntity(scoreDirector, this.sourceVariableDescriptor.getEntityDescriptor().getEntityClass(), entity -> this.insert(scoreDirector, entity));
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.retract(scoreDirector, event.entity());
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.insert(scoreDirector, event.entity());
    }

    protected void insert(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Object shadowValue = this.shadowVariableDescriptor.getValue(shadowEntity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && shadowValue != null) {
                throw new IllegalStateException("The entity (" + String.valueOf(entity) + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + String.valueOf(shadowEntity) + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + String.valueOf(shadowValue) + ") which is not null.\nVerify the consistency of your input problem for that sourceVariableName variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            this.shadowVariableDescriptor.setValue(shadowEntity, entity);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    protected void retract(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Object shadowValue = this.shadowVariableDescriptor.getValue(shadowEntity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && shadowValue != entity) {
                throw new IllegalStateException("The entity (" + String.valueOf(entity) + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + String.valueOf(shadowEntity) + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + String.valueOf(shadowValue) + ") which is not that entity.\nVerify the consistency of your input problem for that sourceVariableName variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            this.shadowVariableDescriptor.setValue(shadowEntity, null);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

