/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.impl.domain.variable.BasicVariableChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.CollectionInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedBasicVariableListener;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public class ExternalizedCollectionInverseVariableSupply<Solution_>
implements SourcedBasicVariableListener<Solution_, Object>,
CollectionInverseVariableSupply {
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Set<Object>> inverseEntitySetMap = null;

    public ExternalizedCollectionInverseVariableSupply(VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(@NonNull InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.inverseEntitySetMap = new IdentityHashMap<Object, Set<Object>>();
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.retract(event.entity());
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.insert(event.entity());
    }

    @Override
    public void close() {
        this.inverseEntitySetMap = null;
    }

    protected void insert(Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Set inverseEntitySet = this.inverseEntitySetMap.computeIfAbsent(value, k -> Collections.newSetFromMap(new IdentityHashMap()));
        boolean addSucceeded = inverseEntitySet.add(entity);
        if (!addSucceeded) {
            throw new IllegalStateException("The supply (" + String.valueOf(this) + ") is corrupted, because the entity (" + String.valueOf(entity) + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be inserted: it was already inserted.");
        }
    }

    protected void retract(Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Set<Object> inverseEntitySet = this.inverseEntitySetMap.get(value);
        boolean removeSucceeded = inverseEntitySet.remove(entity);
        if (!removeSucceeded) {
            throw new IllegalStateException("The supply (" + String.valueOf(this) + ") is corrupted, because the entity (" + String.valueOf(entity) + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be retracted: it was never inserted.");
        }
        if (inverseEntitySet.isEmpty()) {
            this.inverseEntitySetMap.put(value, null);
        }
    }

    @Override
    public Collection<?> getInverseCollection(Object value) {
        Set<Object> inverseEntitySet = this.inverseEntitySetMap.get(value);
        if (inverseEntitySet == null) {
            return Collections.emptySet();
        }
        return inverseEntitySet;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

