/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.domain.variable.ShadowSources;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.variable.declarative.PathPart;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;

class PathPartIterator
implements Iterator<PathPart> {
    private final Class<?> rootEntity;
    private final String[] parts;
    private final String path;
    private PathPart previous;

    public PathPartIterator(Class<?> rootEntity, String[] parts, String path) {
        this.rootEntity = rootEntity;
        this.parts = parts;
        this.path = path;
        this.previous = new PathPart(-1, "", null, rootEntity, rootEntity, false);
    }

    @Override
    public boolean hasNext() {
        return this.previous.index() < this.parts.length - 1;
    }

    @Override
    public PathPart next() {
        PathPart out;
        Type memberGenericType;
        Class<?> memberType;
        Class<?> previousType;
        Member member;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int index = this.previous.index() + 1;
        String name = this.parts[index];
        boolean isCollection = false;
        if (name.endsWith("[]")) {
            name = name.substring(0, name.length() - "[]".length());
            isCollection = true;
        }
        if ((member = RootVariableSource.getMember(this.rootEntity, this.path, previousType = this.previous.isCollection() ? ConfigUtils.extractGenericTypeParameterOrFail(ShadowSources.class.getSimpleName(), this.previous.memberType(), this.previous.memberType(), this.previous.memberGenericType(), ShadowSources.class, this.previous.name()) : this.previous.memberType(), name)) instanceof Field) {
            Field field = (Field)member;
            memberType = field.getType();
            memberGenericType = field.getGenericType();
        } else if (member instanceof Method) {
            Method method = (Method)member;
            memberType = method.getReturnType();
            memberGenericType = method.getGenericReturnType();
        } else {
            throw new IllegalStateException("Unsupported member type: " + String.valueOf(member.getClass()));
        }
        this.previous = out = new PathPart(index, name, member, memberType, memberGenericType, isCollection);
        return out;
    }
}

