/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.BavetRootNode;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.TupleRecorder;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.RecordingTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetPrecomputeBuildHelper;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class RecordAndReplayPropagator<Tuple_ extends AbstractTuple>
implements Propagator {
    private final Set<Object> retractQueue;
    private final Set<Object> updateQueue;
    private final Set<Object> insertQueue;
    private final Set<Object> seenEntitySet;
    private final Set<Object> seenFactSet;
    private final Supplier<BavetPrecomputeBuildHelper<Tuple_>> precomputeBuildHelperSupplier;
    private final UnaryOperator<Tuple_> internalTupleToOutputTupleMapper;
    private final Map<Object, List<Tuple_>> objectToOutputTuplesMap;
    private final Map<Class<?>, Boolean> objectClassToIsEntitySourceClass;
    private final StaticPropagationQueue<Tuple_> propagationQueue;

    public RecordAndReplayPropagator(Supplier<BavetPrecomputeBuildHelper<Tuple_>> precomputeBuildHelperSupplier, UnaryOperator<Tuple_> internalTupleToOutputTupleMapper, TupleLifecycle<Tuple_> nextNodesTupleLifecycle, int size) {
        this.precomputeBuildHelperSupplier = precomputeBuildHelperSupplier;
        this.internalTupleToOutputTupleMapper = internalTupleToOutputTupleMapper;
        this.objectToOutputTuplesMap = CollectionUtils.newIdentityHashMap(size);
        this.retractQueue = CollectionUtils.newIdentityHashSet(size / 20);
        this.updateQueue = CollectionUtils.newIdentityHashSet(size / 20 * 18);
        this.insertQueue = CollectionUtils.newIdentityHashSet(size / 20);
        this.objectClassToIsEntitySourceClass = new HashMap();
        this.seenEntitySet = CollectionUtils.newIdentityHashSet(size);
        this.seenFactSet = CollectionUtils.newIdentityHashSet(size);
        this.propagationQueue = new StaticPropagationQueue<Tuple_>(nextNodesTupleLifecycle);
    }

    public RecordAndReplayPropagator(Supplier<BavetPrecomputeBuildHelper<Tuple_>> precomputeBuildHelperSupplier, UnaryOperator<Tuple_> internalTupleToOutputTupleMapper, TupleLifecycle<Tuple_> nextNodesTupleLifecycle) {
        this(precomputeBuildHelperSupplier, internalTupleToOutputTupleMapper, nextNodesTupleLifecycle, 1000);
    }

    public void insert(Object object) {
        this.insertQueue.add(object);
    }

    public void update(Object object) {
        this.updateQueue.add(object);
    }

    public void retract(Object object) {
        if (!this.insertQueue.remove(object)) {
            this.retractQueue.add(object);
        }
    }

    @Override
    public void propagateRetracts() {
        if (!this.retractQueue.isEmpty() || !this.insertQueue.isEmpty()) {
            BavetPrecomputeBuildHelper<Tuple_> precomputeBuildHelper = this.precomputeBuildHelperSupplier.get();
            NodeNetwork internalNodeNetwork = precomputeBuildHelper.getNodeNetwork();
            HashMap objectClassToRootNodes = new HashMap();
            RecordingTupleLifecycle<Tuple_> recordingTupleLifecycle = precomputeBuildHelper.getRecordingTupleLifecycle();
            this.invalidateCache();
            this.seenEntitySet.removeAll(this.retractQueue);
            this.seenFactSet.removeAll(this.retractQueue);
            for (Object entity : this.seenEntitySet) {
                for (BavetRootNode<Object> bavetRootNode : RecordAndReplayPropagator.getRootNodes(entity, internalNodeNetwork, objectClassToRootNodes)) {
                    bavetRootNode.insert(entity);
                }
            }
            for (Object fact : this.seenFactSet) {
                for (BavetRootNode<Object> bavetRootNode : RecordAndReplayPropagator.getRootNodes(fact, internalNodeNetwork, objectClassToRootNodes)) {
                    bavetRootNode.insert(fact);
                }
            }
            for (Object object : this.insertQueue) {
                if (this.objectClassToIsEntitySourceClass.computeIfAbsent(object.getClass(), precomputeBuildHelper::isSourceEntityClass).booleanValue()) {
                    this.seenEntitySet.add(object);
                } else {
                    this.seenFactSet.add(object);
                }
                for (BavetRootNode<Object> bavetRootNode : RecordAndReplayPropagator.getRootNodes(object, internalNodeNetwork, objectClassToRootNodes)) {
                    bavetRootNode.insert(object);
                }
            }
            this.updateQueue.clear();
            this.retractQueue.clear();
            this.insertQueue.clear();
            internalNodeNetwork.settle();
            this.recalculateTuples(internalNodeNetwork, objectClassToRootNodes, recordingTupleLifecycle);
            this.propagationQueue.propagateRetracts();
        }
    }

    private static <A> List<BavetRootNode<A>> getRootNodes(Object object, NodeNetwork internalNodeNetwork, Map<Class<?>, List<BavetRootNode<?>>> objectClassToRootNodes) {
        return objectClassToRootNodes.computeIfAbsent(object.getClass(), clazz -> {
            ArrayList out = new ArrayList();
            internalNodeNetwork.getRootNodesAcceptingType(object.getClass()).forEach(out::add);
            return out;
        });
    }

    @Override
    public void propagateUpdates() {
        Set<AbstractTuple> updatedTuples = CollectionUtils.newIdentityHashSet(2 * this.updateQueue.size());
        for (Object update : this.updateQueue) {
            updatedTuples.addAll((Collection)this.objectToOutputTuplesMap.get(update));
        }
        this.updateQueue.clear();
        updatedTuples.forEach(this.propagationQueue::update);
        this.propagationQueue.propagateUpdates();
    }

    @Override
    public void propagateInserts() {
        this.propagationQueue.propagateInserts();
    }

    private void insertIfAbsent(Tuple_ tuple) {
        TupleState state = ((AbstractTuple)tuple).state;
        if (state != TupleState.CREATING) {
            this.propagationQueue.insert(tuple);
        }
    }

    private void retractIfPresent(Tuple_ tuple) {
        TupleState state = ((AbstractTuple)tuple).state;
        if (state.isDirty()) {
            if (state == TupleState.DYING || state == TupleState.ABORTING) {
                return;
            }
            this.propagationQueue.retract(tuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
        } else {
            this.propagationQueue.retract(tuple, TupleState.DYING);
        }
    }

    private void invalidateCache() {
        this.objectToOutputTuplesMap.values().stream().flatMap(Collection::stream).forEach(this::retractIfPresent);
        this.objectToOutputTuplesMap.clear();
    }

    private void recalculateTuples(NodeNetwork internalNodeNetwork, Map<Class<?>, List<BavetRootNode<?>>> classToRootNodeList, RecordingTupleLifecycle<Tuple_> recordingTupleLifecycle) {
        IdentityHashMap internalTupleToOutputTupleMap = new IdentityHashMap(this.seenEntitySet.size());
        for (Object invalidated : this.seenEntitySet) {
            ArrayList mappedTuples = new ArrayList();
            try (RecordingTupleLifecycle<Tuple_> unusedActiveRecordingLifecycle = recordingTupleLifecycle.recordInto(new TupleRecorder(mappedTuples, this.internalTupleToOutputTupleMapper, internalTupleToOutputTupleMap));){
                classToRootNodeList.get(invalidated.getClass()).forEach(node -> node.update(invalidated));
                internalNodeNetwork.settle();
            }
            if (mappedTuples.isEmpty()) {
                this.objectToOutputTuplesMap.put(invalidated, Collections.emptyList());
                continue;
            }
            this.objectToOutputTuplesMap.put(invalidated, mappedTuples);
        }
        this.objectToOutputTuplesMap.values().stream().flatMap(Collection::stream).forEach(this::insertIfAbsent);
    }
}

