/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet;

import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.impl.bavet.common.BavetRootNode;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public record NodeNetwork(Map<Class<?>, List<BavetRootNode<?>>> declaredClassToNodeMap, Propagator[][] layeredNodes) {
    public static final NodeNetwork EMPTY = new NodeNetwork(Map.of(), new Propagator[0][0]);

    public int forEachNodeCount() {
        return this.declaredClassToNodeMap.size();
    }

    public int layerCount() {
        return this.layeredNodes.length;
    }

    public Stream<BavetRootNode<?>> getRootNodes() {
        return this.declaredClassToNodeMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream());
    }

    public Stream<BavetRootNode<?>> getRootNodesAcceptingType(Class<?> factClass) {
        return this.declaredClassToNodeMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).filter(tupleSourceRoot -> factClass == PlanningSolution.class || tupleSourceRoot.allowsInstancesOf(factClass));
    }

    public void settle() {
        for (int layerIndex = 0; layerIndex < this.layerCount(); ++layerIndex) {
            NodeNetwork.settleLayer(this.layeredNodes[layerIndex]);
        }
    }

    private static void settleLayer(Propagator[] nodesInLayer) {
        int nodeCount = nodesInLayer.length;
        if (nodeCount == 1) {
            nodesInLayer[0].propagateEverything();
        } else {
            for (Propagator node : nodesInLayer) {
                node.propagateRetracts();
            }
            for (Propagator node : nodesInLayer) {
                node.propagateUpdates();
            }
            for (Propagator node : nodesInLayer) {
                node.propagateInserts();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeNetwork)) {
            return false;
        }
        NodeNetwork that = (NodeNetwork)o;
        return Objects.equals(this.declaredClassToNodeMap, that.declaredClassToNodeMap) && Objects.deepEquals(this.layeredNodes, that.layeredNodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.declaredClassToNodeMap, Arrays.deepHashCode((Object[])this.layeredNodes));
    }

    @Override
    public String toString() {
        return "%s with %d forEach nodes.".formatted(this.getClass().getSimpleName(), this.forEachNodeCount());
    }
}

