/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet;

import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.BavetRootNode;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AbstractSession {
    private final NodeNetwork nodeNetwork;
    private final Map<Class<?>, BavetRootNode<Object>[]> insertEffectiveClassToNodeArrayMap;
    private final Map<Class<?>, BavetRootNode<Object>[]> updateEffectiveClassToNodeArrayMap;
    private final Map<Class<?>, BavetRootNode<Object>[]> retractEffectiveClassToNodeArrayMap;

    protected AbstractSession(NodeNetwork nodeNetwork) {
        this.nodeNetwork = nodeNetwork;
        this.insertEffectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
        this.updateEffectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
        this.retractEffectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
    }

    public final void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        for (BavetRootNode<Object> node : this.findNodes(factClass, BavetRootNode.LifecycleOperation.INSERT)) {
            node.insert(fact);
        }
    }

    private BavetRootNode<Object>[] findNodes(Class<?> factClass, BavetRootNode.LifecycleOperation lifecycleOperation) {
        Map<Class<?>, BavetRootNode<Object>[]> effectiveClassToNodeArrayMap = switch (lifecycleOperation) {
            default -> throw new IncompatibleClassChangeError();
            case BavetRootNode.LifecycleOperation.INSERT -> this.insertEffectiveClassToNodeArrayMap;
            case BavetRootNode.LifecycleOperation.UPDATE -> this.updateEffectiveClassToNodeArrayMap;
            case BavetRootNode.LifecycleOperation.RETRACT -> this.retractEffectiveClassToNodeArrayMap;
        };
        BavetRootNode<Object>[] nodeArray = effectiveClassToNodeArrayMap.get(factClass);
        if (nodeArray == null) {
            nodeArray = (BavetRootNode[])this.nodeNetwork.getRootNodesAcceptingType(factClass).filter(node -> node.supports(lifecycleOperation)).toArray(BavetRootNode[]::new);
            effectiveClassToNodeArrayMap.put(factClass, nodeArray);
        }
        return nodeArray;
    }

    public final void update(Object fact) {
        Class<?> factClass = fact.getClass();
        for (BavetRootNode<Object> node : this.findNodes(factClass, BavetRootNode.LifecycleOperation.UPDATE)) {
            node.update(fact);
        }
    }

    public final void retract(Object fact) {
        Class<?> factClass = fact.getClass();
        for (BavetRootNode<Object> node : this.findNodes(factClass, BavetRootNode.LifecycleOperation.RETRACT)) {
            node.retract(fact);
        }
    }

    public void settle() {
        this.nodeNetwork.settle();
    }
}

