/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.value;

import ai.timefold.solver.core.api.domain.common.ComparatorFactory;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Comparator;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"id", "mimicSelectorRef", "downcastEntityClass", "variableName", "cacheType", "selectionOrder", "nearbySelectionConfig", "filterClass", "sorterManner", "sorterComparatorClass", "comparatorClass", "sorterWeightFactoryClass", "comparatorFactoryClass", "sorterOrder", "sorterClass", "probabilityWeightFactoryClass", "selectedCountLimit"})
@NullMarked
public class ValueSelectorConfig
extends SelectorConfig<ValueSelectorConfig> {
    @XmlAttribute
    protected @Nullable String id = null;
    @XmlAttribute
    protected @Nullable String mimicSelectorRef = null;
    protected @Nullable Class<?> downcastEntityClass = null;
    @XmlAttribute
    protected @Nullable String variableName = null;
    protected @Nullable SelectionCacheType cacheType = null;
    protected @Nullable SelectionOrder selectionOrder = null;
    @XmlElement(name="nearbySelection")
    protected @Nullable NearbySelectionConfig nearbySelectionConfig = null;
    protected @Nullable Class<? extends SelectionFilter> filterClass = null;
    protected @Nullable ValueSorterManner sorterManner = null;
    @Deprecated(forRemoval=true, since="1.28.0")
    protected @Nullable Class<? extends Comparator> sorterComparatorClass = null;
    protected @Nullable Class<? extends Comparator> comparatorClass = null;
    @Deprecated(forRemoval=true, since="1.28.0")
    protected @Nullable Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected @Nullable Class<? extends ComparatorFactory> comparatorFactoryClass = null;
    protected @Nullable SelectionSorterOrder sorterOrder = null;
    protected @Nullable Class<? extends SelectionSorter> sorterClass = null;
    protected @Nullable Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;
    protected @Nullable Long selectedCountLimit = null;

    public ValueSelectorConfig() {
    }

    public ValueSelectorConfig(String variableName) {
        this.variableName = variableName;
    }

    public ValueSelectorConfig(@Nullable ValueSelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public @Nullable String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public @Nullable String getMimicSelectorRef() {
        return this.mimicSelectorRef;
    }

    public void setMimicSelectorRef(@Nullable String mimicSelectorRef) {
        this.mimicSelectorRef = mimicSelectorRef;
    }

    public @Nullable Class<?> getDowncastEntityClass() {
        return this.downcastEntityClass;
    }

    public void setDowncastEntityClass(@Nullable Class<?> downcastEntityClass) {
        this.downcastEntityClass = downcastEntityClass;
    }

    public @Nullable String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(@Nullable String variableName) {
        this.variableName = variableName;
    }

    public @Nullable SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(@Nullable SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public @Nullable SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(@Nullable SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public @Nullable NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(@Nullable NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public @Nullable Class<? extends SelectionFilter> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(@Nullable Class<? extends SelectionFilter> filterClass) {
        this.filterClass = filterClass;
    }

    public @Nullable ValueSorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(@Nullable ValueSorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public @Nullable Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public void setSorterComparatorClass(@Nullable Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public @Nullable Class<? extends Comparator> getComparatorClass() {
        return this.comparatorClass;
    }

    public void setComparatorClass(@Nullable Class<? extends Comparator> comparatorClass) {
        this.comparatorClass = comparatorClass;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public @Nullable Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public void setSorterWeightFactoryClass(@Nullable Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public @Nullable Class<? extends ComparatorFactory> getComparatorFactoryClass() {
        return this.comparatorFactoryClass;
    }

    public void setComparatorFactoryClass(@Nullable Class<? extends ComparatorFactory> comparatorFactoryClass) {
        this.comparatorFactoryClass = comparatorFactoryClass;
    }

    public @Nullable SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(@Nullable SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public @Nullable Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(@Nullable Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public @Nullable Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(@Nullable Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public @Nullable Long getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(@Nullable Long selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public ValueSelectorConfig withId(String id) {
        this.setId(id);
        return this;
    }

    public ValueSelectorConfig withMimicSelectorRef(String mimicSelectorRef) {
        this.setMimicSelectorRef(mimicSelectorRef);
        return this;
    }

    public ValueSelectorConfig withDowncastEntityClass(Class<?> entityClass) {
        this.setDowncastEntityClass(entityClass);
        return this;
    }

    public ValueSelectorConfig withVariableName(String variableName) {
        this.setVariableName(variableName);
        return this;
    }

    public ValueSelectorConfig withCacheType(SelectionCacheType cacheType) {
        this.setCacheType(cacheType);
        return this;
    }

    public ValueSelectorConfig withSelectionOrder(SelectionOrder selectionOrder) {
        this.setSelectionOrder(selectionOrder);
        return this;
    }

    public ValueSelectorConfig withNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.setNearbySelectionConfig(nearbySelectionConfig);
        return this;
    }

    public ValueSelectorConfig withFilterClass(Class<? extends SelectionFilter> filterClass) {
        this.setFilterClass(filterClass);
        return this;
    }

    public ValueSelectorConfig withSorterManner(ValueSorterManner sorterManner) {
        this.setSorterManner(sorterManner);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public ValueSelectorConfig withSorterComparatorClass(Class<? extends Comparator> comparatorClass) {
        this.setSorterComparatorClass(comparatorClass);
        return this;
    }

    public ValueSelectorConfig withComparatorClass(Class<? extends Comparator> comparatorClass) {
        this.setComparatorClass(comparatorClass);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public ValueSelectorConfig withSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> weightFactoryClass) {
        this.setSorterWeightFactoryClass(weightFactoryClass);
        return this;
    }

    public ValueSelectorConfig withComparatorFactoryClass(Class<? extends ComparatorFactory> comparatorFactoryClass) {
        this.setComparatorFactoryClass(comparatorFactoryClass);
        return this;
    }

    public ValueSelectorConfig withSorterOrder(SelectionSorterOrder sorterOrder) {
        this.setSorterOrder(sorterOrder);
        return this;
    }

    public ValueSelectorConfig withSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.setSorterClass(sorterClass);
        return this;
    }

    public ValueSelectorConfig withProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> factoryClass) {
        this.setProbabilityWeightFactoryClass(factoryClass);
        return this;
    }

    public ValueSelectorConfig withSelectedCountLimit(long selectedCountLimit) {
        this.setSelectedCountLimit(selectedCountLimit);
        return this;
    }

    @Override
    public ValueSelectorConfig inherit(ValueSelectorConfig inheritedConfig) {
        this.id = ConfigUtils.inheritOverwritableProperty(this.id, inheritedConfig.getId());
        this.mimicSelectorRef = ConfigUtils.inheritOverwritableProperty(this.mimicSelectorRef, inheritedConfig.getMimicSelectorRef());
        this.downcastEntityClass = ConfigUtils.inheritOverwritableProperty(this.downcastEntityClass, inheritedConfig.getDowncastEntityClass());
        this.variableName = ConfigUtils.inheritOverwritableProperty(this.variableName, inheritedConfig.getVariableName());
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.getNearbySelectionConfig());
        this.filterClass = ConfigUtils.inheritOverwritableProperty(this.filterClass, inheritedConfig.getFilterClass());
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.comparatorClass = ConfigUtils.inheritOverwritableProperty(this.comparatorClass, inheritedConfig.getComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.comparatorFactoryClass = ConfigUtils.inheritOverwritableProperty(this.comparatorFactoryClass, inheritedConfig.getComparatorFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
        return this;
    }

    @Override
    public ValueSelectorConfig copyConfig() {
        return new ValueSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.downcastEntityClass);
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.visitReferencedClasses(classVisitor);
        }
        classVisitor.accept(this.filterClass);
        classVisitor.accept(this.sorterComparatorClass);
        classVisitor.accept(this.comparatorClass);
        classVisitor.accept(this.sorterWeightFactoryClass);
        classVisitor.accept(this.comparatorFactoryClass);
        classVisitor.accept(this.sorterClass);
        classVisitor.accept(this.probabilityWeightFactoryClass);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + ")";
    }

    public static <Solution_> boolean hasSorter(ValueSorterManner valueSorterManner, GenuineVariableDescriptor<Solution_> variableDescriptor) {
        return switch (valueSorterManner) {
            default -> throw new IncompatibleClassChangeError();
            case ValueSorterManner.NONE -> false;
            case ValueSorterManner.INCREASING_STRENGTH, ValueSorterManner.DECREASING_STRENGTH, ValueSorterManner.ASCENDING, ValueSorterManner.DESCENDING -> true;
            case ValueSorterManner.INCREASING_STRENGTH_IF_AVAILABLE, ValueSorterManner.ASCENDING_IF_AVAILABLE -> {
                if (variableDescriptor.getAscendingSorter() != null) {
                    yield true;
                }
                yield false;
            }
            case ValueSorterManner.DECREASING_STRENGTH_IF_AVAILABLE, ValueSorterManner.DESCENDING_IF_AVAILABLE -> variableDescriptor.getDescendingSorter() != null;
        };
    }

    public static <Solution_> SelectionSorter<Solution_, Object> determineSorter(ValueSorterManner valueSorterManner, GenuineVariableDescriptor<Solution_> variableDescriptor) {
        SelectionSorter<Solution_, Object> sorter;
        switch (valueSorterManner) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                throw new IllegalStateException("Impossible state: hasSorter() should have returned null.");
            }
            case INCREASING_STRENGTH: 
            case ASCENDING: 
            case INCREASING_STRENGTH_IF_AVAILABLE: 
            case ASCENDING_IF_AVAILABLE: {
                SelectionSorter<Solution_, Object> selectionSorter = variableDescriptor.getAscendingSorter();
                break;
            }
            case DECREASING_STRENGTH: 
            case DESCENDING: 
            case DECREASING_STRENGTH_IF_AVAILABLE: 
            case DESCENDING_IF_AVAILABLE: {
                SelectionSorter<Solution_, Object> selectionSorter = sorter = variableDescriptor.getDescendingSorter();
            }
        }
        if (sorter == null) {
            throw new IllegalArgumentException("The sorterManner (%s) on entity class (%s)'s variable (%s) fails because that variable getter's @%s annotation does not declare any strength comparison.".formatted(new Object[]{valueSorterManner, variableDescriptor.getEntityDescriptor().getEntityClass(), variableDescriptor.getVariableName(), PlanningVariable.class.getSimpleName()}));
        }
        return sorter;
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.nearbySelectionConfig != null;
    }
}

