/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.SolverConfigOverride;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import java.io.File;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface SolverFactory<Solution_> {
    public static <Solution_> @NonNull SolverFactory<Solution_> createFromXmlResource(@NonNull String solverConfigResource) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource(solverConfigResource);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> @NonNull SolverFactory<Solution_> createFromXmlResource(@NonNull String solverConfigResource, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource(solverConfigResource, classLoader);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> @NonNull SolverFactory<Solution_> createFromXmlFile(@NonNull File solverConfigFile) {
        SolverConfig solverConfig = SolverConfig.createFromXmlFile(solverConfigFile);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> @NonNull SolverFactory<Solution_> createFromXmlFile(@NonNull File solverConfigFile, @Nullable ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlFile(solverConfigFile, classLoader);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> @NonNull SolverFactory<Solution_> create(@NonNull SolverConfig solverConfig) {
        Objects.requireNonNull(solverConfig);
        solverConfig = new SolverConfig(solverConfig);
        return new DefaultSolverFactory(solverConfig);
    }

    default public @NonNull Solver<Solution_> buildSolver() {
        return this.buildSolver(new SolverConfigOverride());
    }

    public @NonNull Solver<Solution_> buildSolver(@NonNull SolverConfigOverride<Solution_> var1);
}

