/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream.bi;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintStream;
import ai.timefold.solver.core.api.score.stream.tri.TriJoiner;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.jspecify.annotations.NonNull;

public interface BiConstraintStream<A, B>
extends ConstraintStream {
    public @NonNull BiConstraintStream<A, B> filter(@NonNull BiPredicate<A, B> var1);

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull UniConstraintStream<C> otherStream) {
        return this.join(otherStream, new TriJoiner[0]);
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner) {
        return this.join(otherStream, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull UniConstraintStream<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull Class<C> otherClass) {
        return this.join(otherClass, new TriJoiner[0]);
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner) {
        return this.join(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull TriConstraintStream<A, B, C> join(@NonNull Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull BiConstraintStream<A, B> ifExists(@NonNull UniConstraintStream<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull BiConstraintStream<A, B> ifExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull BiConstraintStream<A, B> ifExistsIncludingUnassigned(@NonNull Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull UniConstraintStream<C> otherStream, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull BiConstraintStream<A, B> ifNotExists(@NonNull UniConstraintStream<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> @NonNull BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(@NonNull Class<C> otherClass, @NonNull TriJoiner<A, B, C> joiner1, @NonNull TriJoiner<A, B, C> joiner2, @NonNull TriJoiner<A, B, C> joiner3, @NonNull TriJoiner<A, B, C> joiner4) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> @NonNull BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(@NonNull Class<C> var1, TriJoiner<A, B, C> ... var2);

    public <ResultContainer_, Result_> @NonNull UniConstraintStream<Result_> groupBy(@NonNull BiConstraintCollector<A, B, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> @NonNull BiConstraintStream<ResultA_, ResultB_> groupBy(@NonNull BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, @NonNull BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> @NonNull TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(@NonNull BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, @NonNull BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, @NonNull BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(@NonNull BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, @NonNull BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, @NonNull BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, @NonNull BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> @NonNull UniConstraintStream<GroupKey_> groupBy(@NonNull BiFunction<A, B, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> @NonNull BiConstraintStream<GroupKey_, Result_> groupBy(@NonNull BiFunction<A, B, GroupKey_> var1, @NonNull BiConstraintCollector<A, B, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> @NonNull TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(@NonNull BiFunction<A, B, GroupKey_> var1, @NonNull BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, @NonNull BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(@NonNull BiFunction<A, B, GroupKey_> var1, @NonNull BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, @NonNull BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, @NonNull BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> @NonNull BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(@NonNull BiFunction<A, B, GroupKeyA_> var1, @NonNull BiFunction<A, B, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> @NonNull TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(@NonNull BiFunction<A, B, GroupKeyA_> var1, @NonNull BiFunction<A, B, GroupKeyB_> var2, @NonNull BiConstraintCollector<A, B, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(@NonNull BiFunction<A, B, GroupKeyA_> var1, @NonNull BiFunction<A, B, GroupKeyB_> var2, @NonNull BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, @NonNull BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> @NonNull TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(@NonNull BiFunction<A, B, GroupKeyA_> var1, @NonNull BiFunction<A, B, GroupKeyB_> var2, @NonNull BiFunction<A, B, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> @NonNull QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(@NonNull BiFunction<A, B, GroupKeyA_> var1, @NonNull BiFunction<A, B, GroupKeyB_> var2, @NonNull BiFunction<A, B, GroupKeyC_> var3, @NonNull BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> @NonNull QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(@NonNull BiFunction<A, B, GroupKeyA_> var1, @NonNull BiFunction<A, B, GroupKeyB_> var2, @NonNull BiFunction<A, B, GroupKeyC_> var3, @NonNull BiFunction<A, B, GroupKeyD_> var4);

    public <ResultA_> @NonNull UniConstraintStream<ResultA_> map(@NonNull BiFunction<A, B, ResultA_> var1);

    public <ResultA_, ResultB_> @NonNull BiConstraintStream<ResultA_, ResultB_> map(@NonNull BiFunction<A, B, @NonNull ResultA_> var1, @NonNull BiFunction<A, B, ResultB_> var2);

    public <ResultA_, ResultB_, ResultC_> @NonNull TriConstraintStream<ResultA_, ResultB_, ResultC_> map(@NonNull BiFunction<A, B, ResultA_> var1, @NonNull BiFunction<A, B, ResultB_> var2, @NonNull BiFunction<A, B, ResultC_> var3);

    public <ResultA_, ResultB_, ResultC_, ResultD_> @NonNull QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> map(@NonNull BiFunction<A, B, ResultA_> var1, @NonNull BiFunction<A, B, ResultB_> var2, @NonNull BiFunction<A, B, ResultC_> var3, @NonNull BiFunction<A, B, ResultD_> var4);

    public <ResultB_> @NonNull BiConstraintStream<A, ResultB_> flattenLast(@NonNull Function<B, @NonNull Iterable<ResultB_>> var1);

    public @NonNull BiConstraintStream<A, B> distinct();

    default public @NonNull BiConstraintStream<A, B> concat(@NonNull UniConstraintStream<A> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.uniConstantNull());
    }

    public @NonNull BiConstraintStream<A, B> concat(@NonNull UniConstraintStream<A> var1, @NonNull Function<A, B> var2);

    public @NonNull BiConstraintStream<A, B> concat(@NonNull BiConstraintStream<A, B> var1);

    default public <C> @NonNull TriConstraintStream<A, B, C> concat(@NonNull TriConstraintStream<A, B, C> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.biConstantNull());
    }

    public <C> @NonNull TriConstraintStream<A, B, C> concat(@NonNull TriConstraintStream<A, B, C> var1, @NonNull BiFunction<A, B, C> var2);

    default public <C, D> @NonNull QuadConstraintStream<A, B, C, D> concat(@NonNull QuadConstraintStream<A, B, C, D> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.biConstantNull(), ConstantLambdaUtils.biConstantNull());
    }

    public <C, D> @NonNull QuadConstraintStream<A, B, C, D> concat(@NonNull QuadConstraintStream<A, B, C, D> var1, @NonNull BiFunction<A, B, C> var2, @NonNull BiFunction<A, B, D> var3);

    public <ResultC_> @NonNull TriConstraintStream<A, B, ResultC_> expand(@NonNull BiFunction<A, B, ResultC_> var1);

    public <ResultC_, ResultD_> @NonNull QuadConstraintStream<A, B, ResultC_, ResultD_> expand(@NonNull BiFunction<A, B, ResultC_> var1, @NonNull BiFunction<A, B, ResultD_> var2);

    default public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> penalize(Score_ constraintWeight) {
        return this.penalize(constraintWeight, ConstantLambdaUtils.biConstantOne());
    }

    default public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> penalizeLong(Score_ constraintWeight) {
        return this.penalizeLong(constraintWeight, ConstantLambdaUtils.biConstantOneLong());
    }

    default public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> penalizeBigDecimal(Score_ constraintWeight) {
        return this.penalizeBigDecimal(constraintWeight, ConstantLambdaUtils.biConstantOneBigDecimal());
    }

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> penalize(@NonNull Score_ var1, @NonNull ToIntBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> penalizeLong(@NonNull Score_ var1, @NonNull ToLongBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> penalizeBigDecimal(@NonNull Score_ var1, @NonNull BiFunction<A, B, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public BiConstraintBuilder<A, B, ?> penalizeConfigurable() {
        return this.penalizeConfigurable(ConstantLambdaUtils.biConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> penalizeConfigurable(ToIntBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> penalizeConfigurableLong(ToLongBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> penalizeConfigurableBigDecimal(BiFunction<A, B, BigDecimal> var1);

    default public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> reward(@NonNull Score_ constraintWeight) {
        return this.reward(constraintWeight, ConstantLambdaUtils.biConstantOne());
    }

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> reward(@NonNull Score_ var1, @NonNull ToIntBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> rewardLong(@NonNull Score_ var1, @NonNull ToLongBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> rewardBigDecimal(@NonNull Score_ var1, @NonNull BiFunction<A, B, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public BiConstraintBuilder<A, B, ?> rewardConfigurable() {
        return this.rewardConfigurable(ConstantLambdaUtils.biConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> rewardConfigurable(ToIntBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> rewardConfigurableLong(ToLongBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> rewardConfigurableBigDecimal(BiFunction<A, B, BigDecimal> var1);

    default public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> impact(@NonNull Score_ constraintWeight) {
        return this.impact(constraintWeight, ConstantLambdaUtils.biConstantOne());
    }

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> impact(@NonNull Score_ var1, @NonNull ToIntBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> impactLong(@NonNull Score_ var1, @NonNull ToLongBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> @NonNull BiConstraintBuilder<A, B, Score_> impactBigDecimal(@NonNull Score_ var1, @NonNull BiFunction<A, B, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public BiConstraintBuilder<A, B, ?> impactConfigurable() {
        return this.impactConfigurable(ConstantLambdaUtils.biConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> impactConfigurable(ToIntBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> impactConfigurableLong(ToLongBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> impactConfigurableBigDecimal(BiFunction<A, B, BigDecimal> var1);

    default public @NonNull BiConstraintStream<A, B> complement(@NonNull Class<A> otherClass) {
        return this.complement(otherClass, ConstantLambdaUtils.uniConstantNull());
    }

    default public @NonNull BiConstraintStream<A, B> complement(@NonNull Class<A> otherClass, @NonNull Function<A, B> paddingFunction) {
        BiConstraintStream firstStream = this;
        UniConstraintStream remapped = firstStream.map(ConstantLambdaUtils.biPickFirst());
        if (firstStream instanceof AbstractConstraintStream) {
            AbstractConstraintStream abstractConstraintStream = (AbstractConstraintStream)((Object)firstStream);
            UniConstraintStream secondStream = switch (abstractConstraintStream.getRetrievalSemantics()) {
                default -> throw new IncompatibleClassChangeError();
                case RetrievalSemantics.STANDARD, RetrievalSemantics.LEGACY -> this.getConstraintFactory().forEach(otherClass);
                case RetrievalSemantics.PRECOMPUTE -> this.getConstraintFactory().forEachUnfiltered(otherClass);
            };
            return firstStream.concat(secondStream.ifNotExists(remapped, Joiners.equal()), paddingFunction);
        }
        throw new IllegalStateException("Impossible state: the %s class (%s) does not extend %s.\n%s are not expected to be implemented by the user.\n".formatted(ConstraintStream.class.getSimpleName(), this.getClass().getSimpleName(), AbstractConstraintStream.class.getSimpleName(), ConstraintStream.class.getSimpleName()));
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        return this.ifExistsIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        return this.ifNotExistsIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated
    default public Constraint rewardConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }
}

