/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.api.score.stream.common.LoadBalance;
import ai.timefold.solver.core.impl.score.stream.collector.LoadBalanceImpl;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import org.jspecify.annotations.NonNull;

final class LoadBalanceBiCollector<A, B, Balanced_>
implements BiConstraintCollector<A, B, LoadBalanceImpl<Balanced_>, LoadBalance<Balanced_>> {
    private final BiFunction<A, B, Balanced_> balancedItemFunction;
    private final ToLongBiFunction<A, B> loadFunction;
    private final ToLongBiFunction<A, B> initialLoadFunction;

    public LoadBalanceBiCollector(BiFunction<A, B, Balanced_> balancedItemFunction, ToLongBiFunction<A, B> loadFunction, ToLongBiFunction<A, B> initialLoadFunction) {
        this.balancedItemFunction = balancedItemFunction;
        this.loadFunction = loadFunction;
        this.initialLoadFunction = initialLoadFunction;
    }

    @Override
    public @NonNull Supplier<LoadBalanceImpl<Balanced_>> supplier() {
        return LoadBalanceImpl::new;
    }

    @Override
    public @NonNull TriFunction<LoadBalanceImpl<Balanced_>, A, B, Runnable> accumulator() {
        return (balanceStatistics, a, b) -> {
            Balanced_ balanced = this.balancedItemFunction.apply(a, b);
            long initialLoad = this.initialLoadFunction.applyAsLong(a, b);
            long load = this.loadFunction.applyAsLong(a, b);
            return balanceStatistics.registerBalanced(balanced, load, initialLoad);
        };
    }

    @Override
    public @NonNull Function<LoadBalanceImpl<Balanced_>, LoadBalance<Balanced_>> finisher() {
        return balanceStatistics -> balanceStatistics;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof LoadBalanceBiCollector)) return false;
        LoadBalanceBiCollector that = (LoadBalanceBiCollector)o;
        if (!Objects.equals(this.balancedItemFunction, that.balancedItemFunction)) return false;
        if (!Objects.equals(this.loadFunction, that.loadFunction)) return false;
        if (!Objects.equals(this.initialLoadFunction, that.initialLoadFunction)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.balancedItemFunction, this.loadFunction, this.initialLoadFunction);
    }
}

