/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.bi;

import ai.timefold.solver.core.impl.bavet.bi.IndexedJoinBiNode;
import ai.timefold.solver.core.impl.bavet.bi.UnindexedJoinBiNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingFilter;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.EnumeratingStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.bi.AbstractBiEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.JoinEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.bridge.ForeBridgeUniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.joiner.DefaultBiEnumeratingJoiner;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public final class JoinBiEnumeratingStream<Solution_, A, B>
extends AbstractBiEnumeratingStream<Solution_, A, B>
implements JoinEnumeratingStream<Solution_> {
    private final ForeBridgeUniEnumeratingStream<Solution_, A> leftParent;
    private final ForeBridgeUniEnumeratingStream<Solution_, B> rightParent;
    private final DefaultBiEnumeratingJoiner<A, B> joiner;
    private final BiEnumeratingFilter<Solution_, A, B> filtering;

    public JoinBiEnumeratingStream(EnumeratingStreamFactory<Solution_> enumeratingStreamFactory, ForeBridgeUniEnumeratingStream<Solution_, A> leftParent, ForeBridgeUniEnumeratingStream<Solution_, B> rightParent, DefaultBiEnumeratingJoiner<A, B> joiner, BiEnumeratingFilter<Solution_, A, B> filtering) {
        super(enumeratingStreamFactory);
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public void collectActiveEnumeratingStreams(Set<AbstractEnumeratingStream<Solution_>> enumeratingStreamSet) {
        this.leftParent.collectActiveEnumeratingStreams(enumeratingStreamSet);
        this.rightParent.collectActiveEnumeratingStreams(enumeratingStreamSet);
        enumeratingStreamSet.add(this);
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        SolutionView<Solution_> solutionView = buildHelper.getSessionContext().solutionView();
        BiPredicate<A, B> filteringDataJoiner = this.filtering == null ? null : this.filtering.toBiPredicate(solutionView);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory<B> indexerFactory = new IndexerFactory<B>(this.joiner.toBiJoiner());
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinBiNode(indexerFactory, buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, filteringDataJoiner, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1) : new UnindexedJoinBiNode(buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, filteringDataJoiner, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof JoinBiEnumeratingStream)) return false;
        JoinBiEnumeratingStream other = (JoinBiEnumeratingStream)o;
        if (!Objects.equals(this.leftParent.getParent(), other.leftParent.getParent())) return false;
        if (!Objects.equals(this.rightParent.getParent(), other.rightParent.getParent())) return false;
        if (!Objects.equals(this.joiner, other.joiner)) return false;
        if (!Objects.equals(this.filtering, other.filtering)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent(), this.joiner, this.filtering);
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }

    @Override
    public AbstractEnumeratingStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public AbstractEnumeratingStream<Solution_> getRightParent() {
        return this.rightParent;
    }
}

