/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.neighborhood.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ChangeMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    protected final PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    protected final Entity_ entity;
    protected final @Nullable Value_ toPlanningValue;
    private @Nullable Value_ currentValue;

    protected ChangeMove(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, @Nullable Value_ toPlanningValue) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.entity = Objects.requireNonNull(entity);
        this.toPlanningValue = toPlanningValue;
    }

    protected @Nullable Value_ getValue() {
        if (this.currentValue == null) {
            this.currentValue = ChangeMove.getVariableDescriptor(this.variableMetaModel).getValue(this.entity);
        }
        return this.currentValue;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        this.getValue();
        solutionView.changeVariable(this.variableMetaModel, this.entity, this.toPlanningValue);
    }

    public ChangeMove<Solution_, Entity_, Value_> rebase(Rebaser rebaser) {
        return new ChangeMove<Solution_, Entity_, Value_>(this.variableMetaModel, Objects.requireNonNull(rebaser.rebase(this.entity)), rebaser.rebase(this.toPlanningValue));
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        return Collections.singletonList(this.entity);
    }

    @Override
    public Collection<Value_> extractPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    @Override
    public List<PlanningVariableMetaModel<Solution_, Entity_, Value_>> variableMetaModels() {
        return Collections.singletonList(this.variableMetaModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ChangeMove)) return false;
        ChangeMove other = (ChangeMove)o;
        if (!Objects.equals(this.variableMetaModel, other.variableMetaModel)) return false;
        if (!Objects.equals(this.entity, other.entity)) return false;
        if (!Objects.equals(this.toPlanningValue, other.toPlanningValue)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.entity, this.toPlanningValue);
    }

    @Override
    public String toString() {
        return String.valueOf(this.entity) + " {" + String.valueOf(this.getValue()) + " -> " + String.valueOf(this.toPlanningValue) + "}";
    }
}

