/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.decider;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.exhaustivesearch.event.ExhaustiveSearchPhaseLifecycleListener;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import ai.timefold.solver.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import ai.timefold.solver.core.impl.neighborhood.MoveRepository;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.preview.api.move.Move;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExhaustiveSearchDecider<Solution_>
implements ExhaustiveSearchPhaseLifecycleListener<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExhaustiveSearchDecider.class);
    private final String logIndentation;
    private final BestSolutionRecaller<Solution_> bestSolutionRecaller;
    private final PhaseTermination<Solution_> termination;
    private final ManualEntityMimicRecorder<Solution_> manualEntityMimicRecorder;
    private final MoveRepository<Solution_> moveRepository;
    private final boolean scoreBounderEnabled;
    private final ScoreBounder<?> scoreBounder;
    private boolean assertMoveScoreFromScratch = false;
    private boolean assertExpectedUndoMoveScore = false;

    public ExhaustiveSearchDecider(String logIndentation, BestSolutionRecaller<Solution_> bestSolutionRecaller, PhaseTermination<Solution_> termination, ManualEntityMimicRecorder<Solution_> manualEntityMimicRecorder, MoveRepository<Solution_> moveRepository, boolean scoreBounderEnabled, ScoreBounder<?> scoreBounder) {
        this.logIndentation = logIndentation;
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.termination = termination;
        this.manualEntityMimicRecorder = manualEntityMimicRecorder;
        this.moveRepository = moveRepository;
        this.scoreBounderEnabled = scoreBounderEnabled;
        this.scoreBounder = scoreBounder;
    }

    public MoveRepository<Solution_> getMoveRepository() {
        return this.moveRepository;
    }

    public boolean isScoreBounderEnabled() {
        return this.scoreBounderEnabled;
    }

    public <Score_ extends Score<Score_>> ScoreBounder<Score_> getScoreBounder() {
        return this.scoreBounder;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.moveRepository.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        this.moveRepository.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(ExhaustiveSearchStepScope<Solution_> stepScope) {
        this.moveRepository.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(ExhaustiveSearchStepScope<Solution_> stepScope) {
        this.moveRepository.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        this.moveRepository.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.moveRepository.solvingEnded(solverScope);
    }

    public void expandNode(ExhaustiveSearchStepScope<Solution_> stepScope) {
        ExhaustiveSearchNode expandingNode = stepScope.getExpandingNode();
        this.manualEntityMimicRecorder.setRecordedEntity(expandingNode.getEntity());
        int moveIndex = 0;
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        ExhaustiveSearchLayer moveLayer = ((ExhaustiveSearchPhaseScope)phaseScope).getLayerList().get(expandingNode.getDepth() + 1);
        for (Move move : this.moveRepository) {
            ExhaustiveSearchNode moveNode = new ExhaustiveSearchNode(moveLayer, expandingNode);
            ++moveIndex;
            moveNode.setMove(move);
            this.doMove(stepScope, moveNode);
            phaseScope.addMoveEvaluationCount(move, 1L);
            phaseScope.getSolverScope().checkYielding();
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        stepScope.setSelectedMoveCount(Long.valueOf(moveIndex));
    }

    private <Score_ extends Score<Score_>> void doMove(ExhaustiveSearchStepScope<Solution_> stepScope, ExhaustiveSearchNode moveNode) {
        InnerScore startingStepScore;
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        Move move = moveNode.getMove();
        Move undoMove = (Move)scoreDirector.getMoveDirector().executeTemporary(move, (score, undo) -> {
            this.processMove(stepScope, moveNode);
            return undo;
        });
        moveNode.setUndoMove(undoMove);
        SolverLifecyclePoint executionPoint = SolverLifecyclePoint.of(stepScope, moveNode.getTreeId());
        if (this.assertExpectedUndoMoveScore && (startingStepScore = stepScope.getStartingStepScore()) != null) {
            scoreDirector.assertExpectedUndoMoveScore(move, startingStepScore, executionPoint);
        }
        InnerScore nodeScore = moveNode.getScore();
        LOGGER.trace("{}        Move treeId ({}), score ({}), expandable ({}), move ({}).", new Object[]{this.logIndentation, executionPoint.treeId(), nodeScore == null ? "null" : nodeScore, moveNode.isExpandable(), moveNode.getMove()});
    }

    private <Score_ extends Score<Score_>> void processMove(ExhaustiveSearchStepScope<Solution_> stepScope, ExhaustiveSearchNode moveNode) {
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        boolean lastLayer = moveNode.isLastLayer();
        if (!this.scoreBounderEnabled) {
            if (lastLayer) {
                InnerScore score = phaseScope.calculateScore();
                moveNode.setScore(score);
                if (this.assertMoveScoreFromScratch) {
                    phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
                }
                this.bestSolutionRecaller.processWorkingSolutionDuringMove(score, stepScope);
            } else {
                ((ExhaustiveSearchPhaseScope)phaseScope).addExpandableNode(moveNode);
            }
        } else {
            InnerScore innerScore = phaseScope.calculateScore();
            moveNode.setScore(innerScore);
            if (this.assertMoveScoreFromScratch) {
                phaseScope.assertWorkingScoreFromScratch(innerScore, moveNode.getMove());
            }
            if (lastLayer) {
                ((ExhaustiveSearchPhaseScope)phaseScope).registerPessimisticBound(innerScore);
                this.bestSolutionRecaller.processWorkingSolutionDuringMove(innerScore, stepScope);
            } else {
                InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
                ScoreBounder castScoreBounder = this.getScoreBounder();
                InnerScore optimisticBound = castScoreBounder.calculateOptimisticBound(scoreDirector, innerScore);
                moveNode.setOptimisticBound(optimisticBound);
                InnerScore bestPessimisticBound = ((ExhaustiveSearchPhaseScope)phaseScope).getBestPessimisticBound();
                if (optimisticBound.compareTo(bestPessimisticBound) > 0) {
                    ((ExhaustiveSearchPhaseScope)phaseScope).addExpandableNode(moveNode);
                    InnerScore<Score_> pessimisticBound = castScoreBounder.calculatePessimisticBound(scoreDirector, innerScore);
                    ((ExhaustiveSearchPhaseScope)phaseScope).registerPessimisticBound(pessimisticBound);
                }
            }
        }
    }
}

