/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.solver.SolutionManager;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSession;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EmptyVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariableUpdaterLookup;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphChangeType;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphStructure;
import ai.timefold.solver.core.impl.domain.variable.declarative.ParentVariableType;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.declarative.SingleDirectionalParentVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalSorter;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.CollectionInverseVariableSupply;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class DefaultShadowVariableSessionFactory<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultShadowVariableSessionFactory.class);
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final IntFunction<TopologicalOrderGraph> graphCreator;

    public DefaultShadowVariableSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, InnerScoreDirector<Solution_, ?> scoreDirector, IntFunction<TopologicalOrderGraph> graphCreator) {
        this.solutionDescriptor = solutionDescriptor;
        this.scoreDirector = scoreDirector;
        this.graphCreator = graphCreator;
    }

    public static <Solution_> VariableReferenceGraph buildGraph(GraphDescriptor<Solution_> graphDescriptor) {
        GraphStructure.GraphStructureAndDirection graphStructureAndDirection = GraphStructure.determineGraphStructure(graphDescriptor.solutionDescriptor(), graphDescriptor.entities());
        LOGGER.trace("Shadow variable graph structure: {}", (Object)graphStructureAndDirection);
        return DefaultShadowVariableSessionFactory.buildGraphForStructureAndDirection(graphStructureAndDirection, graphDescriptor);
    }

    static <Solution_> VariableReferenceGraph buildGraphForStructureAndDirection(GraphStructure.GraphStructureAndDirection graphStructureAndDirection, GraphDescriptor<Solution_> graphDescriptor) {
        return switch (graphStructureAndDirection.structure()) {
            default -> throw new IncompatibleClassChangeError();
            case GraphStructure.EMPTY -> EmptyVariableReferenceGraph.INSTANCE;
            case GraphStructure.SINGLE_DIRECTIONAL_PARENT -> {
                InnerScoreDirector scoreDirector = graphDescriptor.variableReferenceGraphBuilder().changedVariableNotifier.innerScoreDirector();
                if (scoreDirector == null) {
                    yield DefaultShadowVariableSessionFactory.buildArbitraryGraph(graphDescriptor);
                }
                yield DefaultShadowVariableSessionFactory.buildSingleDirectionalParentGraph(graphDescriptor, graphStructureAndDirection);
            }
            case GraphStructure.ARBITRARY_SINGLE_ENTITY_AT_MOST_ONE_DIRECTIONAL_PARENT_TYPE -> DefaultShadowVariableSessionFactory.buildArbitrarySingleEntityGraph(graphDescriptor);
            case GraphStructure.NO_DYNAMIC_EDGES, GraphStructure.ARBITRARY -> DefaultShadowVariableSessionFactory.buildArbitraryGraph(graphDescriptor);
        };
    }

    static <Solution_> VariableReferenceGraph buildSingleDirectionalParentGraph(GraphDescriptor<Solution_> graphDescriptor, GraphStructure.GraphStructureAndDirection graphStructureAndDirection) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariables = graphDescriptor.solutionDescriptor().getDeclarativeShadowVariableDescriptors();
        List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeVariables = DefaultShadowVariableSessionFactory.topologicallySortedDeclarativeShadowVariables(declarativeShadowVariables);
        TopologicalSorter topologicalSorter = DefaultShadowVariableSessionFactory.getTopologicalSorter(graphDescriptor.solutionDescriptor(), Objects.requireNonNull(graphDescriptor.changedVariableNotifier().innerScoreDirector()), Objects.requireNonNull(graphStructureAndDirection.direction()));
        return new SingleDirectionalParentVariableReferenceGraph<Solution_>(graphDescriptor.consistencyTracker(), sortedDeclarativeVariables, topologicalSorter, graphDescriptor.changedVariableNotifier(), graphDescriptor.entities());
    }

    private static <Solution_> List<DeclarativeShadowVariableDescriptor<Solution_>> topologicallySortedDeclarativeShadowVariables(List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariables) {
        LinkedHashMap<String, Integer> nameToIndex = new LinkedHashMap<String, Integer>();
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariables) {
            nameToIndex.put(declarativeShadowVariableDescriptor.getVariableName(), nameToIndex.size());
        }
        DefaultTopologicalOrderGraph graph = new DefaultTopologicalOrderGraph(nameToIndex.size());
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariables) {
            Integer toIndex = (Integer)nameToIndex.get(declarativeShadowVariableDescriptor.getVariableName());
            HashSet<Integer> visited = new HashSet<Integer>();
            for (RootVariableSource<?, ?> source : declarativeShadowVariableDescriptor.getSources()) {
                Integer fromIndex;
                VariableSourceReference variableReference;
                VariableMetaModel<?, ?, ?> sourceDeclarativeVariable;
                List<VariableSourceReference> variableReferences = source.variableSourceReferences();
                if (source.parentVariableType() != ParentVariableType.NO_PARENT || (sourceDeclarativeVariable = (variableReference = variableReferences.get(0)).downstreamDeclarativeVariableMetamodel()) == null || !visited.add(fromIndex = (Integer)nameToIndex.get(sourceDeclarativeVariable.name()))) continue;
                graph.addEdge(fromIndex, toIndex);
            }
        }
        graph.commitChanges(new BitSet());
        ArrayList<DeclarativeShadowVariableDescriptor<Solution_>> arrayList = new ArrayList<DeclarativeShadowVariableDescriptor<Solution_>>(declarativeShadowVariables);
        arrayList.sort(Comparator.comparingInt(variable -> graph.getTopologicalOrder((Integer)nameToIndex.get(variable.getVariableName())).order()).thenComparing(VariableDescriptor::getVariableName));
        return arrayList;
    }

    private static <Solution_> TopologicalSorter getTopologicalSorter(SolutionDescriptor<Solution_> solutionDescriptor, InnerScoreDirector<Solution_, ?> scoreDirector, ParentVariableType parentVariableType) {
        return switch (parentVariableType) {
            case ParentVariableType.PREVIOUS -> {
                ListVariableStateSupply listStateSupply = scoreDirector.getListVariableStateSupply(solutionDescriptor.getListVariableDescriptor());
                yield new TopologicalSorter(listStateSupply::getNextElement, Comparator.comparingInt(entity -> Objects.requireNonNullElse(listStateSupply.getIndex(entity), 0)), listStateSupply::getInverseSingleton);
            }
            case ParentVariableType.NEXT -> {
                ListVariableStateSupply listStateSupply = scoreDirector.getListVariableStateSupply(solutionDescriptor.getListVariableDescriptor());
                yield new TopologicalSorter(listStateSupply::getPreviousElement, Comparator.comparingInt(entity -> Objects.requireNonNullElse(listStateSupply.getIndex(entity), 0)).reversed(), listStateSupply::getInverseSingleton);
            }
            default -> throw new IllegalStateException("Impossible state: expected parentVariableType to be previous or next but was %s.".formatted(new Object[]{parentVariableType}));
        };
    }

    private static <Solution_> VariableReferenceGraph buildArbitraryGraph(GraphDescriptor<Solution_> graphDescriptor) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = graphDescriptor.solutionDescriptor().getDeclarativeShadowVariableDescriptors();
        EntityVariableUpdaterLookup variableIdToUpdater = EntityVariableUpdaterLookup.entityIndependentLookup();
        Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap = DefaultShadowVariableSessionFactory.createGraphNodes(graphDescriptor, declarativeShadowVariableDescriptors, variableIdToUpdater);
        return DefaultShadowVariableSessionFactory.buildVariableReferenceGraph(graphDescriptor, declarativeShadowVariableDescriptors, declarativeShadowVariableToAliasMap);
    }

    private static <Solution_> VariableReferenceGraph buildVariableReferenceGraph(GraphDescriptor<Solution_> graphDescriptor, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap) {
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable : declarativeShadowVariableDescriptors) {
            VariableMetaModel fromVariableId = declarativeShadowVariable.getVariableMetaModel();
            DefaultShadowVariableSessionFactory.createSourceChangeProcessors(graphDescriptor, declarativeShadowVariable, fromVariableId);
            Set<VariableSourceReference> aliasSet = declarativeShadowVariableToAliasMap.get(fromVariableId);
            if (aliasSet == null) continue;
            DefaultShadowVariableSessionFactory.createAliasToVariableChangeProcessors(graphDescriptor.variableReferenceGraphBuilder(), aliasSet, fromVariableId);
        }
        DefaultShadowVariableSessionFactory.createFixedVariableRelationEdges(graphDescriptor.variableReferenceGraphBuilder(), graphDescriptor.entities(), declarativeShadowVariableDescriptors);
        return graphDescriptor.variableReferenceGraphBuilder().build(graphDescriptor.graphCreator());
    }

    private static <Solution_> Map<VariableMetaModel<Solution_, ?, ?>, GroupVariableUpdaterInfo<Solution_>> getGroupVariableUpdaterInfoMap(ConsistencyTracker<Solution_> consistencyTracker, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, Object[] entities) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeVariableDescriptors = DefaultShadowVariableSessionFactory.topologicallySortedDeclarativeShadowVariables(declarativeShadowVariableDescriptors);
        HashMap groupIndexToVariables = new HashMap();
        ArrayList<DeclarativeShadowVariableDescriptor<Solution_>> groupVariables = new ArrayList<DeclarativeShadowVariableDescriptor<Solution_>>();
        groupIndexToVariables.put(0, groupVariables);
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : sortedDeclarativeVariableDescriptors) {
            boolean previousHasAlignmentKey;
            boolean hasGroupSources = Arrays.stream(declarativeShadowVariableDescriptor.getSources()).anyMatch(rootVariableSource -> rootVariableSource.parentVariableType() == ParentVariableType.GROUP);
            boolean hasAlignmentKey = declarativeShadowVariableDescriptor.getAlignmentKeyMap() != null;
            boolean bl = previousHasAlignmentKey = !groupVariables.isEmpty() && ((DeclarativeShadowVariableDescriptor)groupVariables.get(0)).getAlignmentKeyMap() != null;
            if (!groupVariables.isEmpty() && (hasGroupSources || hasAlignmentKey || previousHasAlignmentKey)) {
                groupVariables = new ArrayList();
                groupIndexToVariables.put(groupIndexToVariables.size(), groupVariables);
            }
            groupVariables.add(declarativeShadowVariableDescriptor);
        }
        HashMap out = new HashMap();
        ArrayList allUpdaters = new ArrayList();
        HashMap groupedUpdaters = new HashMap();
        int updaterKey = 0;
        for (int entryKey = 0; entryKey < groupIndexToVariables.size(); ++entryKey) {
            List entryGroupVariables = (List)groupIndexToVariables.get(entryKey);
            ArrayList updaters = new ArrayList();
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : entryGroupVariables) {
                VariableUpdaterInfo updater2 = new VariableUpdaterInfo(declarativeShadowVariableDescriptor.getVariableMetaModel(), updaterKey, declarativeShadowVariableDescriptor, consistencyTracker.getDeclarativeEntityConsistencyState(declarativeShadowVariableDescriptor.getEntityDescriptor()), declarativeShadowVariableDescriptor.getMemberAccessor(), declarativeShadowVariableDescriptor.getCalculator()::executeGetter);
                if (declarativeShadowVariableDescriptor.getAlignmentKeyMap() != null) {
                    Function<Object, Object> alignmentKeyFunction = declarativeShadowVariableDescriptor.getAlignmentKeyMap();
                    HashMap<Object, List> alignmentKeyToAlignedEntitiesMap = new HashMap<Object, List>();
                    for (Object entity : entities) {
                        if (!declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass().isInstance(entity)) continue;
                        Object alignmentKey = alignmentKeyFunction.apply(entity);
                        alignmentKeyToAlignedEntitiesMap.computeIfAbsent(alignmentKey, k -> new ArrayList()).add(entity);
                    }
                    for (Map.Entry entry : alignmentKeyToAlignedEntitiesMap.entrySet()) {
                        VariableUpdaterInfo updaterCopy = updater2.withGroupId(updaterKey);
                        if (entry.getKey() == null) {
                            updaters.add(updaterCopy);
                            allUpdaters.add(updaterCopy);
                        } else {
                            updaterCopy = updaterCopy.withGroupEntities(((List)entry.getValue()).toArray(new Object[0]));
                            Map variableUpdaterMap = groupedUpdaters.computeIfAbsent(declarativeShadowVariableDescriptor, ignored -> new IdentityHashMap());
                            for (Object entity : (List)entry.getValue()) {
                                variableUpdaterMap.put(entity, updaterCopy);
                            }
                        }
                        ++updaterKey;
                    }
                    --updaterKey;
                    continue;
                }
                updaters.add(updater2);
                allUpdaters.add(updater2);
            }
            GroupVariableUpdaterInfo<Solution_> groupVariableUpdaterInfo = new GroupVariableUpdaterInfo<Solution_>(sortedDeclarativeVariableDescriptors, allUpdaters, updaters, groupedUpdaters);
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : entryGroupVariables) {
                out.put(declarativeShadowVariableDescriptor.getVariableMetaModel(), groupVariableUpdaterInfo);
            }
            ++updaterKey;
        }
        allUpdaters.replaceAll(updater -> updater.withGroupId(groupIndexToVariables.size()));
        return out;
    }

    private static <Solution_> VariableReferenceGraph buildArbitrarySingleEntityGraph(GraphDescriptor<Solution_> graphDescriptor) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = graphDescriptor.solutionDescriptor().getDeclarativeShadowVariableDescriptors();
        HashMap alignmentKeyMappers = new HashMap();
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
            if (declarativeShadowVariableDescriptor.getAlignmentKeyMap() == null) continue;
            alignmentKeyMappers.put(declarativeShadowVariableDescriptor.getVariableMetaModel(), declarativeShadowVariableDescriptor.getAlignmentKeyMap());
        }
        EntityVariableUpdaterLookup variableIdToUpdater = alignmentKeyMappers.isEmpty() ? EntityVariableUpdaterLookup.entityDependentLookup() : EntityVariableUpdaterLookup.groupedEntityDependentLookup(alignmentKeyMappers::get);
        Map variableIdToGroupedUpdater = DefaultShadowVariableSessionFactory.getGroupVariableUpdaterInfoMap(graphDescriptor.consistencyTracker(), declarativeShadowVariableDescriptors, graphDescriptor.entities());
        Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap = DefaultShadowVariableSessionFactory.createGraphNodes(graphDescriptor, declarativeShadowVariableDescriptors, variableIdToUpdater, (entity, declarativeShadowVariable, variableId) -> ((GroupVariableUpdaterInfo)variableIdToGroupedUpdater.get(variableId)).getUpdatersForEntityVariable(entity, declarativeShadowVariable));
        return DefaultShadowVariableSessionFactory.buildVariableReferenceGraph(graphDescriptor, declarativeShadowVariableDescriptors, declarativeShadowVariableToAliasMap);
    }

    private static <Solution_> Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> createGraphNodes(GraphDescriptor<Solution_> graphDescriptor, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, EntityVariableUpdaterLookup<Solution_> variableIdToUpdaters) {
        return DefaultShadowVariableSessionFactory.createGraphNodes(graphDescriptor, declarativeShadowVariableDescriptors, variableIdToUpdaters, (entity, declarativeShadowVariableDescriptor, variableId) -> Collections.singletonList(new VariableUpdaterInfo(variableId, variableIdToUpdaters.getNextId(), declarativeShadowVariableDescriptor, graphDescriptor.consistencyTracker().getDeclarativeEntityConsistencyState(declarativeShadowVariableDescriptor.getEntityDescriptor()), declarativeShadowVariableDescriptor.getMemberAccessor(), declarativeShadowVariableDescriptor.getCalculator()::executeGetter)));
    }

    private static <Solution_> Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> createGraphNodes(GraphDescriptor<Solution_> graphDescriptor, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, EntityVariableUpdaterLookup<Solution_> variableIdToUpdaters, TriFunction<Object, DeclarativeShadowVariableDescriptor<Solution_>, VariableMetaModel<Solution_, ?, ?>, List<VariableUpdaterInfo<Solution_>>> entityVariableToUpdatersMapper) {
        HashMap result = new HashMap();
        for (Object entity : graphDescriptor.entities()) {
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel variableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                List<VariableUpdaterInfo<Solution_>> updaters = variableIdToUpdaters.computeUpdatersForVariableOnEntity(variableId, entity, () -> (List)entityVariableToUpdatersMapper.apply(entity, declarativeShadowVariableDescriptor, variableId));
                graphDescriptor.variableReferenceGraphBuilder.addVariableReferenceEntity(entity, updaters);
                for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (source.downstreamDeclarativeVariableMetamodel() == null) continue;
                        result.computeIfAbsent(source.downstreamDeclarativeVariableMetamodel(), ignored -> new LinkedHashSet()).add(source);
                    }
                }
            }
        }
        return result;
    }

    private static <Solution_> void createSourceChangeProcessors(GraphDescriptor<Solution_> graphDescriptor, DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (RootVariableSource<?, ?> source : declarativeShadowVariable.getSources()) {
            ArrayList<VariableSourceReference> parentVariableList = new ArrayList<VariableSourceReference>();
            ArrayList<Function<Object, Collection>> parentInverseFunctionList = new ArrayList<Function<Object, Collection>>();
            boolean parentIsOnRootEntity = false;
            for (VariableSourceReference sourcePart : source.variableSourceReferences()) {
                VariableMetaModel<?, ?, ?> toVariableId = sourcePart.variableMetaModel();
                if (!sourcePart.isDeclarative()) {
                    if (sourcePart.onRootEntity()) {
                        graphDescriptor.variableReferenceGraphBuilder().addAfterProcessor(GraphChangeType.NO_CHANGE, toVariableId, (graph, entity) -> {
                            GraphNode changed = graph.lookupOrNull(fromVariableId, entity);
                            if (changed != null) {
                                graph.markChanged(changed);
                            }
                        });
                        parentInverseFunctionList.add(Collections::singletonList);
                        parentIsOnRootEntity = true;
                    } else {
                        Function<Object, Object> inverseFunction;
                        if (parentVariableList.isEmpty()) {
                            IdentityHashMap inverseMap = new IdentityHashMap();
                            BiConsumer<Object, Consumer<Object>> visitor = source.getEntityVisitor(sourcePart.chainFromRootEntityToVariableEntity());
                            for (Object rootEntity : graphDescriptor.entities()) {
                                if (!declarativeShadowVariable.getEntityDescriptor().getEntityClass().isInstance(rootEntity)) continue;
                                visitor.accept(rootEntity, shadowEntity -> inverseMap.computeIfAbsent(shadowEntity, ignored -> new ArrayList()).add(rootEntity));
                            }
                            inverseFunction = entity -> inverseMap.getOrDefault(entity, Collections.emptyList());
                        } else {
                            int parentIndex = parentVariableList.size() - 1;
                            VariableMetaModel<?, ?, ?> parentVariable = ((VariableSourceReference)parentVariableList.get(parentIndex)).variableMetaModel();
                            CollectionInverseVariableSupply inverseSupply = graphDescriptor.variableReferenceGraphBuilder().changedVariableNotifier.getCollectionInverseVariableSupply(parentVariable);
                            inverseFunction = parentIsOnRootEntity ? inverseSupply::getInverseCollection : entity -> {
                                Collection<?> inverses = inverseSupply.getInverseCollection(entity);
                                Function parentInverseFunction = (Function)parentInverseFunctionList.get(parentIndex);
                                ArrayList out = new ArrayList(inverses.size());
                                for (Object inverse : inverses) {
                                    out.addAll((Collection)parentInverseFunction.apply(inverse));
                                }
                                return out;
                            };
                        }
                        graphDescriptor.variableReferenceGraphBuilder().addAfterProcessor(GraphChangeType.NO_CHANGE, toVariableId, (graph, entity) -> {
                            for (Object item : (Collection)inverseFunction.apply(entity)) {
                                GraphNode changed = graph.lookupOrNull(fromVariableId, item);
                                if (changed == null) continue;
                                graph.markChanged(changed);
                            }
                        });
                        parentInverseFunctionList.add(inverseFunction);
                        parentIsOnRootEntity = false;
                    }
                }
                parentVariableList.add(sourcePart);
            }
        }
    }

    private static <Solution_> void createAliasToVariableChangeProcessors(VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Set<VariableSourceReference> aliasSet, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (VariableSourceReference alias : aliasSet) {
            VariableMetaModel<?, ?, ?> toVariableId = alias.targetVariableMetamodel();
            VariableMetaModel<?, ?, ?> sourceVariableId = alias.variableMetaModel();
            if (alias.isDeclarative() || !alias.affectGraphEdges()) continue;
            variableReferenceGraphBuilder.addBeforeProcessor(GraphChangeType.REMOVE_EDGE, sourceVariableId, (graph, toEntity) -> {
                GraphNode to = graph.lookupOrNull(toVariableId, toEntity);
                if (to == null) {
                    return;
                }
                Object fromEntity = alias.targetEntityFunctionStartingFromVariableEntity().apply(toEntity);
                if (fromEntity == null) {
                    return;
                }
                GraphNode from = graph.lookupOrNull(fromVariableId, fromEntity);
                if (from == null) {
                    return;
                }
                graph.removeEdge(from, to);
            });
            variableReferenceGraphBuilder.addAfterProcessor(GraphChangeType.ADD_EDGE, sourceVariableId, (graph, toEntity) -> {
                GraphNode to = graph.lookupOrNull(toVariableId, toEntity);
                if (to == null) {
                    return;
                }
                Object fromEntity = alias.findTargetEntity(toEntity);
                if (fromEntity == null) {
                    return;
                }
                GraphNode from = graph.lookupOrNull(fromVariableId, fromEntity);
                if (from == null) {
                    return;
                }
                graph.addEdge(from, to);
            });
        }
    }

    private static <Solution_> void createFixedVariableRelationEdges(VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors) {
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel toVariableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                GraphNode to = variableReferenceGraphBuilder.lookupOrError(toVariableId, entity);
                block2: for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (!source.isTopLevel() || !source.isDeclarative()) continue;
                        VariableMetaModel<?, ?, ?> fromVariableId = source.variableMetaModel();
                        sourceRoot.valueEntityFunction().accept(entity, fromEntity -> {
                            GraphNode from = variableReferenceGraphBuilder.lookupOrError(fromVariableId, fromEntity);
                            variableReferenceGraphBuilder.addFixedEdge(from, to);
                        });
                        continue block2;
                    }
                }
            }
        }
    }

    public DefaultShadowVariableSession<Solution_> forSolution(ConsistencyTracker<Solution_> consistencyTracker, Solution_ solution) {
        ArrayList entities = new ArrayList();
        this.solutionDescriptor.visitAllEntities(solution, entities::add);
        return this.forEntities(consistencyTracker, entities.toArray());
    }

    public DefaultShadowVariableSession<Solution_> forEntities(ConsistencyTracker<Solution_> consistencyTracker, Object ... entities) {
        VariableReferenceGraph graph = DefaultShadowVariableSessionFactory.buildGraph(new GraphDescriptor<Solution_>(this.solutionDescriptor, ChangedVariableNotifier.of(this.scoreDirector), entities).withConsistencyTracker(consistencyTracker).withGraphCreator(this.graphCreator));
        return new DefaultShadowVariableSession(graph);
    }

    public record GraphDescriptor<Solution_>(ConsistencyTracker<Solution_> consistencyTracker, SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, IntFunction<TopologicalOrderGraph> graphCreator) {
        public GraphDescriptor(SolutionDescriptor<Solution_> solutionDescriptor, ChangedVariableNotifier<Solution_> changedVariableNotifier, Object ... entities) {
            this(new ConsistencyTracker(), solutionDescriptor, new VariableReferenceGraphBuilder<Solution_>(changedVariableNotifier), entities, DefaultTopologicalOrderGraph::new);
        }

        public GraphDescriptor<Solution_> withGraphCreator(IntFunction<TopologicalOrderGraph> graphCreator) {
            return new GraphDescriptor<Solution_>(this.consistencyTracker, this.solutionDescriptor, this.variableReferenceGraphBuilder, this.entities, graphCreator);
        }

        public GraphDescriptor<Solution_> withConsistencyTracker(ConsistencyTracker<Solution_> consistencyTracker) {
            return new GraphDescriptor<Solution_>(consistencyTracker, this.solutionDescriptor, this.variableReferenceGraphBuilder, this.entities, this.graphCreator);
        }

        public GraphDescriptor<Solution_> assertingNoReferencedMissingEntities() {
            Set<Object> entitySet = CollectionUtils.newIdentityHashSet(this.entities.length);
            entitySet.addAll(Arrays.asList(this.entities));
            HashSet<MissingEntity> missingEntitySet = new HashSet<MissingEntity>();
            List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowDescriptors = this.solutionDescriptor.getDeclarativeShadowVariableDescriptors();
            do {
                missingEntitySet.stream().map(MissingEntity::missingReferredEntity).forEach(entitySet::add);
            } while (this.addDiscoveredEntities(declarativeShadowDescriptors, entitySet, missingEntitySet));
            if (missingEntitySet.isEmpty()) {
                return this;
            }
            int LIMIT = 5;
            throw new IllegalArgumentException("Found referenced entities that were not given:\n\n%s\n%s\nWhen ConstraintVerifier.verifyThat().given(...) or\n%s.updateShadowVariables(solutionClass, ...) is used,\nall referenced entities must be passed in as arguments.\nMaybe add the missing entities as arguments?\n".formatted(missingEntitySet.stream().map(MissingEntity::getMessage).sorted().limit(LIMIT).collect(Collectors.joining("  - ", "  - ", "")), missingEntitySet.size() > LIMIT ? "(%d more...)%n".formatted(missingEntitySet.size() - LIMIT) : "", SolutionManager.class.getSimpleName()));
        }

        private boolean addDiscoveredEntities(List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowDescriptors, Set<Object> entitySet, HashSet<MissingEntity> missingEntitySet) {
            int originalMissingCount = missingEntitySet.size();
            for (Object entity : entitySet) {
                for (DeclarativeShadowVariableDescriptor shadowDescriptor : declarativeShadowDescriptors) {
                    if (!shadowDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(entity.getClass())) continue;
                    shadowDescriptor.visitAllReferencedEntities(entity, (source, maybeMissingEntity) -> {
                        if (!entitySet.contains(maybeMissingEntity)) {
                            missingEntitySet.add(new MissingEntity(entity, maybeMissingEntity, shadowDescriptor, (RootVariableSource<?, ?>)source));
                        }
                    });
                }
            }
            return missingEntitySet.size() != originalMissingCount;
        }

        public ChangedVariableNotifier<Solution_> changedVariableNotifier() {
            return this.variableReferenceGraphBuilder.changedVariableNotifier;
        }
    }

    private record GroupVariableUpdaterInfo<Solution_>(List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeVariableDescriptors, List<VariableUpdaterInfo<Solution_>> allUpdaters, List<VariableUpdaterInfo<Solution_>> groupedUpdaters, Map<DeclarativeShadowVariableDescriptor<Solution_>, Map<Object, VariableUpdaterInfo<Solution_>>> variableToEntityToGroupUpdater) {
        public List<VariableUpdaterInfo<Solution_>> getUpdatersForEntityVariable(Object entity, DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor) {
            VariableUpdaterInfo<Solution_> updater;
            if (this.variableToEntityToGroupUpdater.containsKey(declarativeShadowVariableDescriptor) && (updater = this.variableToEntityToGroupUpdater.get(declarativeShadowVariableDescriptor).get(entity)) != null) {
                return List.of(updater);
            }
            for (DeclarativeShadowVariableDescriptor<Solution_> shadowVariableDescriptor : this.sortedDeclarativeVariableDescriptors) {
                for (RootVariableSource<?, ?> rootSource : shadowVariableDescriptor.getSources()) {
                    if (rootSource.parentVariableType() != ParentVariableType.GROUP) continue;
                    MutableInt visitedCount = new MutableInt();
                    rootSource.valueEntityFunction().accept(entity, ignored -> visitedCount.increment());
                    if (visitedCount.intValue() <= 0) continue;
                    return this.groupedUpdaters;
                }
            }
            return this.allUpdaters;
        }
    }

    private record MissingEntity(Object sourceEntity, Object missingReferredEntity, DeclarativeShadowVariableDescriptor<?> referringShadowVariable, RootVariableSource<?, ?> referredVariableSource) {
        String getMessage() {
            return "The entity's (%s) shadow variable (%s) refers to a declarative shadow variable on a non-given entity (%s)\nvariable via the source path (%s).\n".formatted(this.sourceEntity, this.referringShadowVariable.getVariableName(), this.missingReferredEntity, this.referredVariableSource.variablePath());
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof MissingEntity)) {
                return false;
            }
            MissingEntity that = (MissingEntity)object;
            return this.missingReferredEntity == that.missingReferredEntity;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.missingReferredEntity);
        }
    }
}

