/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.descriptor;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.EmptyValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.collection.SetValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public abstract class AbstractFromPropertyValueRangeDescriptor<Solution_>
extends AbstractValueRangeDescriptor<Solution_> {
    protected final MemberAccessor memberAccessor;
    protected boolean collectionWrapping;
    protected boolean arrayWrapping;
    protected boolean countable;
    private final boolean isGenericTypeImmutable;

    protected AbstractFromPropertyValueRangeDescriptor(int ordinalId, GenuineVariableDescriptor<Solution_> variableDescriptor, MemberAccessor memberAccessor) {
        super(ordinalId, variableDescriptor);
        this.memberAccessor = memberAccessor;
        ValueRangeProvider valueRangeProviderAnnotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The member (%s) must have a valueRangeProviderAnnotation (%s).".formatted(memberAccessor, valueRangeProviderAnnotation));
        }
        Class<?> type = memberAccessor.getType();
        this.collectionWrapping = Collection.class.isAssignableFrom(type);
        this.arrayWrapping = type.isArray();
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
        if (this.collectionWrapping) {
            Class<?> genericType = ConfigUtils.extractGenericTypeParameterOrFail("solutionClass or entityClass", memberAccessor.getDeclaringClass(), memberAccessor.getType(), memberAccessor.getGenericType(), ValueRangeProvider.class, memberAccessor.getName());
            this.isGenericTypeImmutable = ConfigUtils.isGenericTypeImmutable(genericType);
        } else {
            this.isGenericTypeImmutable = true;
        }
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        Class<?> arrayElementClass;
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        Class<?> type = this.memberAccessor.getType();
        if (!(this.collectionWrapping || this.arrayWrapping || ValueRange.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) that refers to a @%s-annotated member (%s) that does not return a %s, an array or a %s.".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariableName(), ValueRangeProvider.class.getSimpleName(), this.memberAccessor, Collection.class.getSimpleName(), ValueRange.class.getSimpleName()));
        }
        if (this.collectionWrapping) {
            Class<?> collectionElementClass = ConfigUtils.extractGenericTypeParameterOrFail("solutionClass or entityClass", this.memberAccessor.getDeclaringClass(), this.memberAccessor.getType(), this.memberAccessor.getGenericType(), ValueRangeProvider.class, this.memberAccessor.getName());
            if (!this.variableDescriptor.acceptsValueType(collectionElementClass)) {
                throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) that refers to a @%s-annotated member (%s) that returns a %s with elements of type (%s) which cannot be assigned to the type of %s (%s).".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariableName(), ValueRangeProvider.class.getSimpleName(), this.memberAccessor, Collection.class.getSimpleName(), collectionElementClass, PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariablePropertyType()));
            }
        } else if (this.arrayWrapping && !this.variableDescriptor.acceptsValueType(arrayElementClass = type.getComponentType())) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) that refers to a @%s-annotated member (%s) that returns an array with elements of type (%s) which cannot be assigned to the type of the @%s (%s);".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariableName(), ValueRangeProvider.class.getSimpleName(), this.memberAccessor, arrayElementClass, PlanningVariable.class.getSimpleName(), this.variableDescriptor.getVariablePropertyType()));
        }
        this.countable = this.collectionWrapping || this.arrayWrapping || CountableValueRange.class.isAssignableFrom(type);
    }

    @Override
    public boolean isCountable() {
        return this.countable;
    }

    protected <Value_> CountableValueRange<Value_> readValueRange(Object bean) {
        Object valueRangeObject = this.memberAccessor.executeGetter(bean);
        if (valueRangeObject == null) {
            throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return a null valueRangeObject (%s).".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, valueRangeObject));
        }
        if (this.arrayWrapping) {
            List<Value_> list = AbstractFromPropertyValueRangeDescriptor.transformArrayToList(valueRangeObject);
            this.assertNullNotPresent(list, bean);
            return this.buildValueRange(list);
        }
        if (this.collectionWrapping) {
            Collection collection = (Collection)valueRangeObject;
            if (collection instanceof Set) {
                Set set = (Set)collection;
                if (!(collection instanceof SortedSet) && !(collection instanceof LinkedHashSet)) {
                    throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) returns a Set (%s) with undefined iteration order.\nUse SortedSet or LinkedHashSet to ensure solver reproducibility.\n".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, set.getClass()));
                }
                if (set.contains(null)) {
                    throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) returns a Set (%s) with a null element.\nMaybe remove that null element from the dataset and use @%s(allowsUnassigned = true) or @%s(allowsUnassignedValues = true) instead.".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, set, PlanningVariable.class.getSimpleName(), PlanningListVariable.class.getSimpleName()));
                }
                return this.buildValueRange(set);
            }
            List list = AbstractFromPropertyValueRangeDescriptor.transformCollectionToList(collection);
            this.assertNullNotPresent(list, bean);
            return this.buildValueRange(list);
        }
        CountableValueRange valueRange = (CountableValueRange)valueRangeObject;
        return valueRange.isEmpty() ? EmptyValueRange.instance() : valueRange;
    }

    private void assertNullNotPresent(List<?> list, Object bean) {
        if (!(list.isEmpty() || list.get(0) != null && list.get(list.size() - 1) != null)) {
            throw new IllegalStateException("The @%s-annotated member (%s) called on bean (%s) must not return a %s (%s) with an element that is null.\nMaybe remove that null element from the dataset and use @%s(allowsUnassigned = true) or @%s(allowsUnassignedValues = true) instead.".formatted(ValueRangeProvider.class.getSimpleName(), this.memberAccessor, bean, this.collectionWrapping ? Collection.class.getSimpleName() : "array", list, PlanningVariable.class.getSimpleName(), PlanningListVariable.class.getSimpleName()));
        }
    }

    private <T> CountableValueRange<T> buildValueRange(Collection<T> valueCollection) {
        if (valueCollection.isEmpty()) {
            return EmptyValueRange.instance();
        }
        if (valueCollection instanceof Set) {
            Set set = (Set)valueCollection;
            return new SetValueRange(set, this.isGenericTypeImmutable);
        }
        if (valueCollection instanceof List) {
            List list = (List)valueCollection;
            return new ListValueRange(list, this.isGenericTypeImmutable);
        }
        throw new IllegalArgumentException("Impossible state: The collection (%s) must be a Set or a List.".formatted(valueCollection));
    }

    public static <Value_> List<Value_> transformArrayToList(Object arrayObject) {
        if (arrayObject == null) {
            return Collections.emptyList();
        }
        Object[] array = (Object[])arrayObject;
        if (array.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    private static <T> List<T> transformCollectionToList(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return Collections.unmodifiableList(list);
        }
        return List.copyOf(collection);
    }
}

