/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.entity.descriptor;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityConsistencyState;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import java.util.Collection;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class EntityForEachFilter<Solution_> {
    private final EntityDescriptor<Solution_> entityDescriptor;
    private final Predicate<Object> assignedPredicate;
    private final boolean hasDeclarativeShadowVariables;

    EntityForEachFilter(EntityDescriptor<Solution_> entityDescriptor) {
        SolutionDescriptor<Solution_> solutionDescriptor = entityDescriptor.getSolutionDescriptor();
        ListVariableDescriptor<Solution_> listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        this.entityDescriptor = entityDescriptor;
        this.assignedPredicate = EntityForEachFilter.getAssignedPredicate(entityDescriptor, listVariableDescriptor);
        this.hasDeclarativeShadowVariables = !EntityForEachFilter.getDeclarativeShadowVariables(entityDescriptor).isEmpty();
    }

    public Predicate<Object> getAssignedAndConsistentPredicate(ConsistencyTracker<Solution_> consistencyTracker) {
        if (!this.hasDeclarativeShadowVariables) {
            return this.assignedPredicate;
        }
        EntityConsistencyState<Solution_, Object> entityConsistencyState = consistencyTracker.getDeclarativeEntityConsistencyState(this.entityDescriptor);
        return this.assignedPredicate.and(entityConsistencyState::isEntityConsistent);
    }

    public @Nullable Predicate<Object> getConsistentPredicate(ConsistencyTracker<Solution_> consistencyTracker) {
        if (!this.hasDeclarativeShadowVariables) {
            return null;
        }
        EntityConsistencyState<Solution_, Object> entityConsistencyState = consistencyTracker.getDeclarativeEntityConsistencyState(this.entityDescriptor);
        return entityConsistencyState::isEntityConsistent;
    }

    private static Collection<? extends ShadowVariableDescriptor> getDeclarativeShadowVariables(EntityDescriptor<?> entityDescriptor) {
        return entityDescriptor.getShadowVariableDescriptors().stream().filter(shadowVariableDescriptor -> shadowVariableDescriptor instanceof DeclarativeShadowVariableDescriptor).toList();
    }

    private static Predicate<Object> getAssignedPredicate(EntityDescriptor<?> entityDescriptor, ListVariableDescriptor<?> listVariableDescriptor) {
        boolean isListVariableValue;
        boolean bl = isListVariableValue = listVariableDescriptor != null && listVariableDescriptor.acceptsValueType(entityDescriptor.getEntityClass());
        if (isListVariableValue) {
            InverseRelationShadowVariableDescriptor<?> listInverseVariable = listVariableDescriptor.getInverseRelationShadowVariableDescriptor();
            if (listInverseVariable != null) {
                return entity -> entityDescriptor.hasNoNullVariables(entity) && listInverseVariable.getValue(entity) != null;
            }
            return ignored -> {
                throw new IllegalStateException("Impossible state: assigned predicate for list variable value should not be used\nwhen there is no inverse relation shadow variable descriptor.\n");
            };
        }
        return entityDescriptor::hasNoNullVariables;
    }
}

