/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet;

import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AbstractSession {
    private final NodeNetwork nodeNetwork;
    private final Map<Class<?>, AbstractForEachUniNode<Object>[]> insertEffectiveClassToNodeArrayMap;
    private final Map<Class<?>, AbstractForEachUniNode<Object>[]> updateEffectiveClassToNodeArrayMap;
    private final Map<Class<?>, AbstractForEachUniNode<Object>[]> retractEffectiveClassToNodeArrayMap;

    protected AbstractSession(NodeNetwork nodeNetwork) {
        this.nodeNetwork = nodeNetwork;
        this.insertEffectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
        this.updateEffectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
        this.retractEffectiveClassToNodeArrayMap = new IdentityHashMap(nodeNetwork.forEachNodeCount());
    }

    public final void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass, AbstractForEachUniNode.LifecycleOperation.INSERT)) {
            node.insert(fact);
        }
    }

    private AbstractForEachUniNode<Object>[] findNodes(Class<?> factClass, AbstractForEachUniNode.LifecycleOperation lifecycleOperation) {
        Map<Class<?>, AbstractForEachUniNode<Object>[]> effectiveClassToNodeArrayMap = switch (lifecycleOperation) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractForEachUniNode.LifecycleOperation.INSERT -> this.insertEffectiveClassToNodeArrayMap;
            case AbstractForEachUniNode.LifecycleOperation.UPDATE -> this.updateEffectiveClassToNodeArrayMap;
            case AbstractForEachUniNode.LifecycleOperation.RETRACT -> this.retractEffectiveClassToNodeArrayMap;
        };
        AbstractForEachUniNode<Object>[] nodeArray = effectiveClassToNodeArrayMap.get(factClass);
        if (nodeArray == null) {
            nodeArray = (AbstractForEachUniNode[])this.nodeNetwork.getForEachNodes(factClass).filter(node -> node.supports(lifecycleOperation)).toArray(AbstractForEachUniNode[]::new);
            effectiveClassToNodeArrayMap.put(factClass, nodeArray);
        }
        return nodeArray;
    }

    public final void update(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass, AbstractForEachUniNode.LifecycleOperation.UPDATE)) {
            node.update(fact);
        }
    }

    public final void retract(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass, AbstractForEachUniNode.LifecycleOperation.RETRACT)) {
            node.retract(fact);
        }
    }

    public void settle() {
        this.nodeNetwork.settle();
    }
}

