/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import java.util.Arrays;

public final class DynamicIntArray {
    private static final double GROWTH_FACTOR = 1.2;
    private static final int MIN_CAPACITY_INCREMENT = 10;
    private final ClearingStrategy clearingStrategy;
    private final int maxLength;
    private int[] array;
    private int firstIndex;
    private int lastIndex;

    public DynamicIntArray() {
        this(Integer.MAX_VALUE);
    }

    public DynamicIntArray(ClearingStrategy clearingStrategy) {
        this(Integer.MAX_VALUE, clearingStrategy);
    }

    public DynamicIntArray(int maxLength) {
        this(maxLength, ClearingStrategy.FULL);
    }

    public DynamicIntArray(int maxLength, ClearingStrategy clearingStrategy) {
        this.maxLength = maxLength;
        this.clearingStrategy = clearingStrategy;
        this.initializeArray();
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.array == null) {
            int initialCapacity = Math.min(10, this.maxLength);
            this.array = new int[initialCapacity];
            this.firstIndex = index;
            this.lastIndex = index;
            this.array[0] = value;
        } else if (index < this.firstIndex) {
            int currentSize = this.lastIndex - this.firstIndex + 1;
            int offset = this.firstIndex - index;
            int requiredCapacity = currentSize + offset;
            int newCapacity = this.calculateNewCapacity(requiredCapacity);
            int[] newArray = new int[newCapacity];
            System.arraycopy(this.array, 0, newArray, offset, currentSize);
            this.array = newArray;
            this.firstIndex = index;
            this.array[0] = value;
        } else if (index > this.lastIndex) {
            int currentSize = this.lastIndex - this.firstIndex + 1;
            int newSize = index - this.firstIndex + 1;
            if (newSize > this.array.length) {
                int newCapacity = this.calculateNewCapacity(newSize);
                int[] newArray = new int[newCapacity];
                System.arraycopy(this.array, 0, newArray, 0, currentSize);
                this.array = newArray;
            }
            this.lastIndex = index;
            this.array[index - this.firstIndex] = value;
        } else {
            this.array[index - this.firstIndex] = value;
        }
    }

    private int calculateNewCapacity(int requiredCapacity) {
        int currentCapacity;
        int n = currentCapacity = this.array != null ? this.array.length : 0;
        if (requiredCapacity <= currentCapacity) {
            return currentCapacity;
        }
        int newCapacity = (int)((double)currentCapacity * 1.2);
        if (newCapacity - currentCapacity < 10) {
            newCapacity = currentCapacity + 10;
        }
        if (newCapacity < requiredCapacity) {
            newCapacity = requiredCapacity;
        }
        return Math.min(newCapacity, this.maxLength);
    }

    public int get(int index) {
        if (index < 0 || index >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.array == null || index < this.firstIndex || index > this.lastIndex) {
            return 0;
        }
        return this.array[index - this.firstIndex];
    }

    boolean containsIndex(int index) {
        return this.array != null && index >= this.firstIndex && index <= this.lastIndex;
    }

    int getFirstIndex() {
        if (this.array == null) {
            throw new IllegalStateException("Array is empty");
        }
        return this.firstIndex;
    }

    int getLastIndex() {
        if (this.array == null) {
            throw new IllegalStateException("Array is empty");
        }
        return this.lastIndex;
    }

    public void clear() {
        if (this.clearingStrategy == ClearingStrategy.FULL) {
            this.initializeArray();
        } else {
            if (this.array == null) {
                return;
            }
            Arrays.fill(this.array, 0, this.lastIndex - this.firstIndex + 1, 0);
        }
    }

    private void initializeArray() {
        this.array = null;
        this.firstIndex = Integer.MAX_VALUE;
        this.lastIndex = Integer.MIN_VALUE;
    }

    public static enum ClearingStrategy {
        FULL,
        PARTIAL;

    }
}

