/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractPhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadSupportingTermination;
import ai.timefold.solver.core.impl.solver.termination.DiminishedReturnsScoreRingBuffer;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class DiminishedReturnsTermination<Solution_, Score_ extends Score<Score_>>
extends AbstractPhaseTermination<Solution_>
implements ChildThreadSupportingTermination<Solution_, SolverScope<Solution_>> {
    static final long NANOS_PER_MILLISECOND = 1000000L;
    private final long slidingWindowNanos;
    private final double minimumImprovementRatio;
    private boolean isGracePeriodActive;
    private boolean isGracePeriodStarted = false;
    private long gracePeriodStartTimeNanos;
    private double gracePeriodSoftestImprovementDouble;
    private final DiminishedReturnsScoreRingBuffer<Score_> scoresByTime;

    public DiminishedReturnsTermination(long slidingWindowMillis, double minimumImprovementRatio) {
        if (slidingWindowMillis < 0L) {
            throw new IllegalArgumentException("The slidingWindowMillis (%d) cannot be negative.".formatted(slidingWindowMillis));
        }
        if (minimumImprovementRatio <= 0.0) {
            throw new IllegalArgumentException("The minimumImprovementRatio (%f) must be positive.".formatted(minimumImprovementRatio));
        }
        this.slidingWindowNanos = slidingWindowMillis * 1000000L;
        this.minimumImprovementRatio = minimumImprovementRatio;
        this.scoresByTime = new DiminishedReturnsScoreRingBuffer();
    }

    public long getSlidingWindowNanos() {
        return this.slidingWindowNanos;
    }

    public double getMinimumImprovementRatio() {
        return this.minimumImprovementRatio;
    }

    private static <Score_ extends Score<Score_>> double softImprovementOrNaNForHarderChange(InnerScore<Score_> start, InnerScore<Score_> end) {
        if (start.equals(end)) {
            return 0.0;
        }
        if (start.unassignedCount() != end.unassignedCount()) {
            return Double.NaN;
        }
        double[] scoreDiffs = end.raw().subtract(start.raw()).toLevelDoubles();
        int softestLevel = scoreDiffs.length - 1;
        for (int i = 0; i < softestLevel; ++i) {
            if (scoreDiffs[i] == 0.0) continue;
            return Double.NaN;
        }
        return scoreDiffs[softestLevel];
    }

    public void start(long startTime, InnerScore<Score_> startingScore) {
        this.resetGracePeriod(startTime, startingScore);
    }

    public void step(long time, InnerScore<Score_> bestScore) {
        this.scoresByTime.put(time, bestScore);
    }

    private void resetGracePeriod(long currentTime, InnerScore<Score_> startingScore) {
        this.gracePeriodStartTimeNanos = currentTime;
        this.isGracePeriodActive = true;
        this.isGracePeriodStarted = true;
        this.scoresByTime.clear();
        this.scoresByTime.put(currentTime, startingScore);
    }

    public boolean isTerminated(long currentTime, InnerScore<Score_> endScore) {
        if (!this.isGracePeriodStarted) {
            return false;
        }
        if (this.isGracePeriodActive) {
            double endpointDiff = DiminishedReturnsTermination.softImprovementOrNaNForHarderChange(this.scoresByTime.peekFirst(), endScore);
            if (Double.isNaN(endpointDiff)) {
                this.resetGracePeriod(currentTime, endScore);
                return false;
            }
            long timeElapsedNanos = currentTime - this.gracePeriodStartTimeNanos;
            if (timeElapsedNanos >= this.slidingWindowNanos) {
                this.isGracePeriodActive = false;
                this.gracePeriodSoftestImprovementDouble = endpointDiff;
                if (endpointDiff < 0.0) {
                    throw new IllegalStateException("Impossible state: The score deteriorated from (%s) to (%s) during the grace period.".formatted(this.scoresByTime.peekFirst(), endScore));
                }
                return endpointDiff == 0.0;
            }
            return false;
        }
        InnerScore<Score_> startScore = this.scoresByTime.pollLatestScoreBeforeTimeAndClearPrior(currentTime - this.slidingWindowNanos);
        double scoreDiff = DiminishedReturnsTermination.softImprovementOrNaNForHarderChange(startScore, endScore);
        if (Double.isNaN(scoreDiff)) {
            this.resetGracePeriod(currentTime, endScore);
            return false;
        }
        if (this.gracePeriodSoftestImprovementDouble == 0.0) {
            return true;
        }
        return scoreDiff / this.gracePeriodSoftestImprovementDouble < this.minimumImprovementRatio;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isTerminated(System.nanoTime(), phaseScope.getBestScore());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return -1.0;
    }

    @Override
    public Termination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new DiminishedReturnsTermination<Solution_, Score_>(this.slidingWindowNanos, this.minimumImprovementRatio);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.isGracePeriodStarted = false;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.scoresByTime.clear();
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        if (!this.isGracePeriodStarted) {
            this.start(System.nanoTime(), stepScope.getPhaseScope().getBestScore());
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        this.step(System.nanoTime(), stepScope.getPhaseScope().getBestScore());
    }

    @Override
    public boolean isApplicableTo(Class<? extends AbstractPhaseScope> phaseScopeClass) {
        return phaseScopeClass != ConstructionHeuristicPhaseScope.class && phaseScopeClass != CustomPhaseScope.class;
    }

    boolean isGracePeriodStarted() {
        return this.isGracePeriodStarted;
    }

    long getGracePeriodStartTimeNanos() {
        return this.gracePeriodStartTimeNanos;
    }

    public String toString() {
        return "DiminishedReturns()";
    }
}

