/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractUniversalTermination;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadSupportingTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ChildThreadPlumbingTermination<Solution_>
extends AbstractUniversalTermination<Solution_>
implements ChildThreadSupportingTermination<Solution_, SolverScope<Solution_>> {
    private boolean terminateChildren = false;

    public synchronized boolean terminateChildren() {
        boolean terminationEarlySuccessful = !this.terminateChildren;
        this.terminateChildren = true;
        return terminationEarlySuccessful;
    }

    @Override
    public synchronized boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        if (Thread.currentThread().isInterrupted()) {
            this.logger.info("A child solver thread got interrupted, so these child solvers are terminating early.");
            this.terminateChildren = true;
        }
        return this.terminateChildren;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return -1.0;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isSolverTerminated(phaseScope.getSolverScope());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return this.calculateSolverTimeGradient(phaseScope.getSolverScope());
    }

    @Override
    public Termination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return this;
    }

    public String toString() {
        return "ChildThreadPlumbing()";
    }
}

