/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.monitoring.statistic;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.SolverStatistic;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MoveCountPerTypeStatistic<Solution_>
implements SolverStatistic<Solution_> {
    private final Map<Solver<Solution_>, PhaseLifecycleListenerAdapter<Solution_>> solverToPhaseLifecycleListenerMap = new WeakHashMap<Solver<Solution_>, PhaseLifecycleListenerAdapter<Solution_>>();

    @Override
    public void unregister(Solver<Solution_> solver) {
        PhaseLifecycleListenerAdapter<Solution_> listener = this.solverToPhaseLifecycleListenerMap.remove(solver);
        if (listener != null) {
            ((DefaultSolver)solver).removePhaseLifecycleListener(listener);
            ((MoveCountPerTypeStatisticListener)listener).unregister(solver);
        }
    }

    @Override
    public void register(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        MoveCountPerTypeStatisticListener listener = new MoveCountPerTypeStatisticListener();
        this.solverToPhaseLifecycleListenerMap.put(solver, listener);
        defaultSolver.addPhaseLifecycleListener(listener);
    }

    private static class MoveCountPerTypeStatisticListener<Solution_>
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private final Map<Tags, Map<String, AtomicLong>> tagsToMoveCountMap = new ConcurrentHashMap<Tags, Map<String, AtomicLong>>();

        private MoveCountPerTypeStatisticListener() {
        }

        @Override
        public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
            Map<String, Long> moveCountPerType = phaseScope.getSolverScope().getMoveEvaluationCountPerType();
            Tags tags = phaseScope.getSolverScope().getMonitoringTags();
            moveCountPerType.forEach((type, count) -> {
                String key = SolverMetric.MOVE_COUNT_PER_TYPE.getMeterId() + "." + type;
                AtomicLong counter = (AtomicLong)Metrics.gauge((String)key, (Iterable)tags, (Number)new AtomicLong(0L));
                if (counter != null) {
                    counter.set((long)count);
                }
                this.registerMoveCountPerType(tags, key, counter);
            });
        }

        private void registerMoveCountPerType(Tags tag, String key, AtomicLong count) {
            this.tagsToMoveCountMap.compute(tag, (tags, countMap) -> {
                if (countMap == null) {
                    countMap = new HashMap<String, AtomicLong>();
                }
                countMap.put(key, count);
                return countMap;
            });
        }

        void unregister(Solver<Solution_> solver) {
            SolverScope solverScope = ((DefaultSolver)solver).getSolverScope();
            this.tagsToMoveCountMap.values().stream().flatMap(v -> v.keySet().stream()).forEach(meter -> Metrics.globalRegistry.remove(new Meter.Id(meter, solverScope.getMonitoringTags(), null, null, Meter.Type.GAUGE)));
        }
    }
}

