/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.event;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.event.SolverEventListener;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.event.AbstractEventSupport;
import ai.timefold.solver.core.impl.solver.event.DefaultBestSolutionChangedEvent;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;

public class SolverEventSupport<Solution_>
extends AbstractEventSupport<SolverEventListener<Solution_>> {
    private final Solver<Solution_> solver;

    public SolverEventSupport(Solver<Solution_> solver) {
        this.solver = solver;
    }

    public void fireBestSolutionChanged(SolverScope<Solution_> solverScope, Solution_ newBestSolution) {
        Iterator it = this.getEventListeners().iterator();
        Long timeMillisSpent = solverScope.getBestSolutionTimeMillisSpent();
        InnerScore bestScore = solverScope.getBestScore();
        if (it.hasNext()) {
            DefaultBestSolutionChangedEvent<Solution_> event = new DefaultBestSolutionChangedEvent<Solution_>(this.solver, (long)timeMillisSpent, newBestSolution, bestScore);
            do {
                ((SolverEventListener)it.next()).bestSolutionChanged(event);
            } while (it.hasNext());
        }
    }
}

