/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.SolverConfigOverride;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.monitoring.MonitoringConfig;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.config.solver.random.RandomType;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.AbstractFromConfigFactory;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhaseFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.PhaseFactory;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactoryFactory;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.change.DefaultProblemChangeDirector;
import ai.timefold.solver.core.impl.solver.random.DefaultRandomFactory;
import ai.timefold.solver.core.impl.solver.random.RandomFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecallerFactory;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.BasicPlumbingTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.impl.solver.termination.TerminationFactory;
import ai.timefold.solver.core.impl.solver.termination.UniversalTermination;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverFactory<Solution_>
implements SolverFactory<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverFactory.class);
    private static final long DEFAULT_RANDOM_SEED = 0L;
    private final Clock clock;
    private final SolverConfig solverConfig;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final ScoreDirectorFactory<Solution_, ?> scoreDirectorFactory;

    public DefaultSolverFactory(SolverConfig solverConfig) {
        this.clock = Objects.requireNonNullElse(solverConfig.getClock(), Clock.systemDefaultZone());
        this.solverConfig = Objects.requireNonNull(solverConfig, "The solverConfig (" + String.valueOf(solverConfig) + ") cannot be null.");
        this.solutionDescriptor = this.buildSolutionDescriptor();
        this.scoreDirectorFactory = this.buildScoreDirectorFactory();
    }

    public Clock getClock() {
        return this.clock;
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public <Score_ extends Score<Score_>> ScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public @NonNull Solver<Solution_> buildSolver(@NonNull SolverConfigOverride<Solution_> configOverride) {
        boolean constraintMatchEnabled;
        Objects.requireNonNull(configOverride, "Invalid configOverride (null) given to SolverFactory.");
        Boolean isDaemon = Objects.requireNonNullElse(this.solverConfig.getDaemon(), false);
        SolverScope solverScope = new SolverScope(this.clock);
        MonitoringConfig monitoringConfig = this.solverConfig.determineMetricConfig();
        solverScope.setMonitoringTags(Tags.empty());
        List<SolverMetric> solverMetricList = Objects.requireNonNull(monitoringConfig.getSolverMetricList());
        List<Object> metricsRequiringConstraintMatchSet = Collections.emptyList();
        if (!solverMetricList.isEmpty()) {
            solverScope.setSolverMetricSet(EnumSet.copyOf(solverMetricList));
            metricsRequiringConstraintMatchSet = solverScope.getSolverMetricSet().stream().filter(SolverMetric::isMetricConstraintMatchBased).filter(solverScope::isMetricEnabled).toList();
        } else {
            solverScope.setSolverMetricSet(EnumSet.noneOf(SolverMetric.class));
        }
        EnvironmentMode environmentMode = this.solverConfig.determineEnvironmentMode();
        boolean isStepAssertOrMore = environmentMode.isStepAssertOrMore();
        boolean bl = constraintMatchEnabled = !metricsRequiringConstraintMatchSet.isEmpty() || isStepAssertOrMore;
        if (constraintMatchEnabled && !isStepAssertOrMore) {
            LOGGER.info("Enabling constraint matching as required by the enabled metrics ({}). This will impact solver performance.", metricsRequiringConstraintMatchSet);
        }
        AbstractScoreDirector castScoreDirector = ((AbstractScoreDirector.AbstractScoreDirectorBuilder)((AbstractScoreDirector.AbstractScoreDirectorBuilder)this.scoreDirectorFactory.createScoreDirectorBuilder().withLookUpEnabled(true)).withConstraintMatchPolicy(constraintMatchEnabled ? ConstraintMatchPolicy.ENABLED : ConstraintMatchPolicy.DISABLED)).build();
        solverScope.setScoreDirector(castScoreDirector);
        solverScope.setProblemChangeDirector(new DefaultProblemChangeDirector(castScoreDirector));
        Integer moveThreadCount = this.resolveMoveThreadCount(true);
        BestSolutionRecaller bestSolutionRecaller = BestSolutionRecallerFactory.create().buildBestSolutionRecaller(environmentMode);
        RandomFactory randomFactory = this.buildRandomFactory(environmentMode);
        Set<PreviewFeature> previewFeaturesEnabled = this.solverConfig.getEnablePreviewFeatureSet();
        HeuristicConfigPolicy configPolicy = new HeuristicConfigPolicy.Builder().withPreviewFeatureSet(previewFeaturesEnabled).withEnvironmentMode(environmentMode).withMoveThreadCount(moveThreadCount).withMoveThreadBufferSize(this.solverConfig.getMoveThreadBufferSize()).withThreadFactoryClass(this.solverConfig.getThreadFactoryClass()).withNearbyDistanceMeterClass(this.solverConfig.getNearbyDistanceMeterClass()).withRandom(randomFactory.createRandom()).withInitializingScoreTrend(this.scoreDirectorFactory.getInitializingScoreTrend()).withSolutionDescriptor(this.solutionDescriptor).withClassInstanceCache(ClassInstanceCache.create()).build();
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination(isDaemon);
        SolverTermination termination = this.buildTermination(basicPlumbingTermination, configPolicy, configOverride);
        List phaseList = this.buildPhaseList(configPolicy, bestSolutionRecaller, termination);
        return new DefaultSolver(environmentMode, randomFactory, bestSolutionRecaller, basicPlumbingTermination, (UniversalTermination)termination, phaseList, solverScope, moveThreadCount == null ? "NONE" : Integer.toString(moveThreadCount));
    }

    public @Nullable Integer resolveMoveThreadCount(boolean enforceMaximum) {
        OptionalInt maybeCount = new MoveThreadCountResolver().resolveMoveThreadCount(this.solverConfig.getMoveThreadCount(), enforceMaximum);
        if (maybeCount.isPresent()) {
            return maybeCount.getAsInt();
        }
        return null;
    }

    private SolverTermination<Solution_> buildTermination(BasicPlumbingTermination<Solution_> basicPlumbingTermination, HeuristicConfigPolicy<Solution_> configPolicy, SolverConfigOverride<Solution_> solverConfigOverride) {
        TerminationConfig terminationConfig = Objects.requireNonNullElseGet(solverConfigOverride.getTerminationConfig(), () -> Objects.requireNonNullElseGet(this.solverConfig.getTerminationConfig(), TerminationConfig::new));
        return TerminationFactory.create(terminationConfig).buildTermination(configPolicy, basicPlumbingTermination);
    }

    private SolutionDescriptor<Solution_> buildSolutionDescriptor() {
        if (this.solverConfig.getSolutionClass() == null) {
            throw new IllegalArgumentException("The solver configuration must have a solutionClass (%s). If you're using the Quarkus extension or Spring Boot starter, it should have been filled in already.".formatted(this.solverConfig.getSolutionClass()));
        }
        if (ConfigUtils.isEmptyCollection(this.solverConfig.getEntityClassList())) {
            throw new IllegalArgumentException("The solver configuration must have at least 1 entityClass (%s). If you're using the Quarkus extension or Spring Boot starter, it should have been filled in already.".formatted(this.solverConfig.getEntityClassList()));
        }
        return SolutionDescriptor.buildSolutionDescriptor(this.solverConfig.getEnablePreviewFeatureSet(), this.solverConfig.determineDomainAccessType(), this.solverConfig.getSolutionClass(), this.solverConfig.getGizmoMemberAccessorMap(), this.solverConfig.getGizmoSolutionClonerMap(), this.solverConfig.getEntityClassList());
    }

    private <Score_ extends Score<Score_>> ScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory() {
        EnvironmentMode environmentMode = this.solverConfig.determineEnvironmentMode();
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = Objects.requireNonNullElseGet(this.solverConfig.getScoreDirectorFactoryConfig(), ScoreDirectorFactoryConfig::new);
        ScoreDirectorFactoryFactory scoreDirectorFactoryFactory = new ScoreDirectorFactoryFactory(scoreDirectorFactoryConfig_);
        return scoreDirectorFactoryFactory.buildScoreDirectorFactory(environmentMode, this.solutionDescriptor);
    }

    public RandomFactory buildRandomFactory(EnvironmentMode environmentMode_) {
        Class<? extends RandomFactory> randomFactoryClass = this.solverConfig.getRandomFactoryClass();
        if (randomFactoryClass != null) {
            RandomType randomType = this.solverConfig.getRandomType();
            Long randomSeed = this.solverConfig.getRandomSeed();
            if (randomType != null || randomSeed != null) {
                throw new IllegalArgumentException("The solverConfig with randomFactoryClass (%s) has a non-null randomType (%s) or a non-null randomSeed (%s).".formatted(new Object[]{randomFactoryClass, randomType, randomSeed}));
            }
            return ConfigUtils.newInstance(this.solverConfig, "randomFactoryClass", randomFactoryClass);
        }
        RandomType randomType_ = Objects.requireNonNullElse(this.solverConfig.getRandomType(), RandomType.JDK);
        Long randomSeed_ = this.solverConfig.getRandomSeed();
        if (this.solverConfig.getRandomSeed() == null && environmentMode_ != EnvironmentMode.NON_REPRODUCIBLE) {
            randomSeed_ = 0L;
        }
        return new DefaultRandomFactory(randomType_, randomSeed_);
    }

    public List<Phase<Solution_>> buildPhaseList(HeuristicConfigPolicy<Solution_> configPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, SolverTermination<Solution_> termination) {
        List<PhaseConfig> phaseConfigList = this.solverConfig.getPhaseConfigList();
        if (ConfigUtils.isEmptyCollection(phaseConfigList)) {
            Collection<EntityDescriptor<Solution_>> genuineEntityDescriptorCollection = configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
            phaseConfigList = new ArrayList<PhaseConfig>(genuineEntityDescriptorCollection.size() + 2);
            for (EntityDescriptor<Solution_> entityDescriptor : genuineEntityDescriptorCollection) {
                if (entityDescriptor.hasBothGenuineListAndBasicVariables()) {
                    phaseConfigList.add(this.buildConstructionHeuristicPhaseConfigForBasicVariable(configPolicy, entityDescriptor));
                    phaseConfigList.add(this.buildConstructionHeuristicPhaseConfigForListVariable(configPolicy, entityDescriptor));
                    continue;
                }
                if (entityDescriptor.hasAnyGenuineListVariables()) {
                    phaseConfigList.add(this.buildConstructionHeuristicPhaseConfigForListVariable(configPolicy, entityDescriptor));
                    continue;
                }
                phaseConfigList.add(this.buildConstructionHeuristicPhaseConfigForBasicVariable(configPolicy, entityDescriptor));
            }
            phaseConfigList.add(new LocalSearchPhaseConfig());
        }
        return PhaseFactory.buildPhases(phaseConfigList, configPolicy, bestSolutionRecaller, termination);
    }

    private ConstructionHeuristicPhaseConfig buildConstructionHeuristicPhaseConfigForBasicVariable(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
        constructionHeuristicPhaseConfig.setEntityPlacerConfig(new QueuedEntityPlacerConfig().withEntitySelectorConfig(AbstractFromConfigFactory.getDefaultEntitySelectorConfigForEntity(configPolicy, entityDescriptor)));
        return constructionHeuristicPhaseConfig;
    }

    private ConstructionHeuristicPhaseConfig buildConstructionHeuristicPhaseConfigForListVariable(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
        ListVariableDescriptor<Solution_> listVariableDescriptor = entityDescriptor.getGenuineListVariableDescriptor();
        constructionHeuristicPhaseConfig.setEntityPlacerConfig(DefaultConstructionHeuristicPhaseFactory.buildListVariableQueuedValuePlacerConfig(configPolicy, listVariableDescriptor));
        return constructionHeuristicPhaseConfig;
    }

    public void ensurePreviewFeature(PreviewFeature previewFeature) {
        HeuristicConfigPolicy.ensurePreviewFeature(previewFeature, this.solverConfig.getEnablePreviewFeatureSet());
    }

    static class MoveThreadCountResolver {
        MoveThreadCountResolver() {
        }

        protected OptionalInt resolveMoveThreadCount(String moveThreadCount) {
            return this.resolveMoveThreadCount(moveThreadCount, true);
        }

        protected OptionalInt resolveMoveThreadCount(String moveThreadCount, boolean enforceMaximum) {
            int resolvedMoveThreadCount;
            int availableProcessorCount = this.getAvailableProcessors();
            if (moveThreadCount == null || moveThreadCount.equals("NONE")) {
                return OptionalInt.empty();
            }
            if (moveThreadCount.equals("AUTO")) {
                resolvedMoveThreadCount = availableProcessorCount - 2;
                if (enforceMaximum && resolvedMoveThreadCount > 4) {
                    resolvedMoveThreadCount = 4;
                }
                if (resolvedMoveThreadCount <= 1) {
                    return OptionalInt.empty();
                }
            } else {
                resolvedMoveThreadCount = ConfigUtils.resolvePoolSize("moveThreadCount", moveThreadCount, "NONE", "AUTO");
            }
            if (resolvedMoveThreadCount < 1) {
                throw new IllegalArgumentException("The moveThreadCount (%s) resulted in a resolvedMoveThreadCount (%d) that is lower than 1.".formatted(moveThreadCount, resolvedMoveThreadCount));
            }
            if (resolvedMoveThreadCount > availableProcessorCount) {
                LOGGER.warn("The resolvedMoveThreadCount ({}) is higher than the availableProcessorCount ({}), which is counter-efficient.", (Object)resolvedMoveThreadCount, (Object)availableProcessorCount);
            }
            return OptionalInt.of(resolvedMoveThreadCount);
        }

        protected int getAvailableProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }
    }
}

