/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.domain.lookup.PlanningId;
import ai.timefold.solver.core.api.solver.ProblemFactChange;
import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.AbstractSolver;
import ai.timefold.solver.core.impl.solver.change.ProblemChangeAdapter;
import ai.timefold.solver.core.impl.solver.random.RandomFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.BasicPlumbingTermination;
import ai.timefold.solver.core.impl.solver.termination.UniversalTermination;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public class DefaultSolver<Solution_>
extends AbstractSolver<Solution_> {
    protected EnvironmentMode environmentMode;
    protected RandomFactory randomFactory;
    protected BasicPlumbingTermination<Solution_> basicPlumbingTermination;
    protected final AtomicBoolean solving = new AtomicBoolean(false);
    protected final SolverScope<Solution_> solverScope;
    private final String moveThreadCountDescription;

    public DefaultSolver(EnvironmentMode environmentMode, RandomFactory randomFactory, BestSolutionRecaller<Solution_> bestSolutionRecaller, BasicPlumbingTermination<Solution_> basicPlumbingTermination, UniversalTermination<Solution_> termination, List<Phase<Solution_>> phaseList, SolverScope<Solution_> solverScope, String moveThreadCountDescription) {
        super(bestSolutionRecaller, termination, phaseList);
        this.environmentMode = environmentMode;
        this.randomFactory = randomFactory;
        this.basicPlumbingTermination = basicPlumbingTermination;
        this.solverScope = solverScope;
        solverScope.setSolver(this);
        this.moveThreadCountDescription = moveThreadCountDescription;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public ScoreDirectorFactory<Solution_, ?> getScoreDirectorFactory() {
        return this.solverScope.getScoreDirector().getScoreDirectorFactory();
    }

    public SolverScope<Solution_> getSolverScope() {
        return this.solverScope;
    }

    public long getTimeMillisSpent() {
        return this.solverScope.getTimeMillisSpent();
    }

    public long getScoreCalculationCount() {
        return this.solverScope.getScoreCalculationCount();
    }

    public long getMoveEvaluationCount() {
        return this.solverScope.getMoveEvaluationCount();
    }

    public long getScoreCalculationSpeed() {
        return this.solverScope.getScoreCalculationSpeed();
    }

    public long getMoveEvaluationSpeed() {
        return this.solverScope.getMoveEvaluationSpeed();
    }

    @Override
    public boolean isSolving() {
        return this.solving.get();
    }

    @Override
    public boolean terminateEarly() {
        boolean terminationEarlySuccessful = this.basicPlumbingTermination.terminateEarly();
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        return terminationEarlySuccessful;
    }

    @Override
    public boolean isTerminateEarly() {
        return this.basicPlumbingTermination.isTerminateEarly();
    }

    @Override
    public boolean addProblemFactChange(@NonNull ProblemFactChange<Solution_> problemFactChange) {
        return this.addProblemFactChanges(Collections.singletonList(problemFactChange));
    }

    @Override
    public boolean addProblemFactChanges(@NonNull List<ProblemFactChange<Solution_>> problemFactChangeList) {
        Objects.requireNonNull(problemFactChangeList, () -> "The list of problem fact changes (" + String.valueOf(problemFactChangeList) + ") cannot be null.");
        return this.basicPlumbingTermination.addProblemChanges(problemFactChangeList.stream().map(ProblemChangeAdapter::create).collect(Collectors.toList()));
    }

    @Override
    public void addProblemChange(@NonNull ProblemChange<Solution_> problemChange) {
        this.addProblemChanges(Collections.singletonList(problemChange));
    }

    @Override
    public void addProblemChanges(@NonNull List<ProblemChange<Solution_>> problemChangeList) {
        Objects.requireNonNull(problemChangeList, () -> "The list of problem changes (" + String.valueOf(problemChangeList) + ") cannot be null.");
        this.basicPlumbingTermination.addProblemChanges(problemChangeList.stream().map(ProblemChangeAdapter::create).toList());
    }

    @Override
    public boolean isEveryProblemChangeProcessed() {
        return this.basicPlumbingTermination.isEveryProblemChangeProcessed();
    }

    @Override
    public boolean isEveryProblemFactChangeProcessed() {
        return this.isEveryProblemChangeProcessed();
    }

    public void setMonitorTagMap(Map<String, String> monitorTagMap) {
        Tags monitoringTags = Objects.requireNonNullElse(monitorTagMap, Collections.emptyMap()).entrySet().stream().map(entry -> Tags.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).reduce(Tags.empty(), Tags::and);
        this.solverScope.setMonitoringTags(monitoringTags);
    }

    @Override
    public final @NonNull Solution_ solve(@NonNull Solution_ problem) {
        LongTaskTimer solveLengthTimer = Metrics.more().longTaskTimer(SolverMetric.SOLVE_DURATION.getMeterId(), new String[0]);
        Counter errorCounter = Metrics.counter((String)SolverMetric.ERROR_COUNT.getMeterId(), (String[])new String[0]);
        this.solverScope.setInitialSolution(Objects.requireNonNull(problem, "The problem must not be null."));
        this.solverScope.setSolver(this);
        this.outerSolvingStarted(this.solverScope);
        boolean restartSolver = true;
        while (restartSolver) {
            LongTaskTimer.Sample sample = solveLengthTimer.start();
            try {
                this.solvingStarted(this.solverScope);
                this.runPhases(this.solverScope);
                this.solvingEnded(this.solverScope);
            }
            catch (Exception e) {
                errorCounter.increment();
                this.solvingError(this.solverScope, e);
                throw e;
            }
            finally {
                sample.stop();
                this.unregisterSolverSpecificMetrics();
            }
            restartSolver = this.checkProblemFactChanges();
        }
        this.outerSolvingEnded(this.solverScope);
        return this.solverScope.getBestSolution();
    }

    public void outerSolvingStarted(SolverScope<Solution_> solverScope) {
        this.solving.set(true);
        this.basicPlumbingTermination.resetTerminateEarly();
        solverScope.setStartingSolverCount(0);
        solverScope.setWorkingRandom(this.randomFactory.createRandom());
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.assertCorrectSolutionState();
        solverScope.startingNow();
        solverScope.getScoreDirector().resetCalculationCount();
        super.solvingStarted(solverScope);
        int startingSolverCount = solverScope.getStartingSolverCount() + 1;
        solverScope.setStartingSolverCount(startingSolverCount);
        this.registerSolverSpecificMetrics();
        this.bestSolutionRecaller.updateBestSolutionAndFireIfInitialized(solverScope);
        this.logger.info("Solving {}: time spent ({}), best score ({}), environment mode ({}), move thread count ({}), random ({}).", new Object[]{startingSolverCount == 1 ? "started" : "restarted", solverScope.calculateTimeMillisSpentUpToNow(), solverScope.getBestScore().raw(), this.environmentMode.name(), this.moveThreadCountDescription, this.randomFactory != null ? this.randomFactory : "not fixed"});
        if (this.logger.isInfoEnabled()) {
            ProblemSizeStatistics problemSizeStatistics = solverScope.getProblemSizeStatistics();
            this.logger.info("Problem scale: entity count ({}), variable count ({}), approximate value count ({}), approximate problem scale ({}).", new Object[]{problemSizeStatistics.entityCount(), problemSizeStatistics.variableCount(), problemSizeStatistics.approximateValueCount(), problemSizeStatistics.approximateProblemScaleAsFormattedString()});
        }
    }

    private void registerSolverSpecificMetrics() {
        this.solverScope.getSolverMetricSet().forEach(solverMetric -> solverMetric.register(this));
    }

    private void unregisterSolverSpecificMetrics() {
        this.solverScope.getSolverMetricSet().forEach(solverMetric -> solverMetric.unregister(this));
    }

    private void assertCorrectSolutionState() {
        Solution_ bestSolution = this.solverScope.getBestSolution();
        this.solverScope.getSolutionDescriptor().visitAllProblemFacts(bestSolution, this::assertNonNullPlanningId);
        this.solverScope.getSolutionDescriptor().visitAllEntities(bestSolution, entity -> {
            this.assertNonNullPlanningId(entity);
            EntityDescriptor entityDescriptor = this.solverScope.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
            if (!entityDescriptor.supportsPinning() || !entityDescriptor.hasAnyGenuineListVariables()) {
                return;
            }
            ListVariableDescriptor<Solution_> listVariableDescriptor = entityDescriptor.getGenuineListVariableDescriptor();
            int pinIndex = listVariableDescriptor.getFirstUnpinnedIndex(entity);
            if (entityDescriptor.isMovable(this.solverScope.getScoreDirector().getWorkingSolution(), entity)) {
                if (pinIndex < 0) {
                    throw new IllegalStateException("The movable planning entity (%s) has a pin index (%s) which is negative.".formatted(entity, pinIndex));
                }
                int listSize = listVariableDescriptor.getListSize(entity);
                if (pinIndex > listSize) {
                    throw new IllegalStateException("The movable planning entity (%s) has a pin index (%s) which is greater than the list size (%s).".formatted(entity, pinIndex, listSize));
                }
            } else if (pinIndex != 0) {
                throw new IllegalStateException("The immovable planning entity (%s) has a pin index (%s) which is not 0.".formatted(entity, pinIndex));
            }
        });
    }

    private void assertNonNullPlanningId(Object fact) {
        Class<?> factClass = fact.getClass();
        MemberAccessor planningIdAccessor = this.solverScope.getSolutionDescriptor().getPlanningIdAccessor(factClass);
        if (planningIdAccessor == null) {
            return;
        }
        Object id = planningIdAccessor.executeGetter(fact);
        if (id == null) {
            throw new IllegalStateException("The planningId (" + String.valueOf(id) + ") of the member (" + String.valueOf(planningIdAccessor) + ") of the class (" + String.valueOf(factClass) + ") on object (" + String.valueOf(fact) + ") must not be null.\nMaybe initialize the planningId of the class (" + String.valueOf(planningIdAccessor.getDeclaringClass()) + ") instance (" + String.valueOf(fact) + ") before solving.\nMaybe remove the @" + PlanningId.class.getSimpleName() + " annotation.");
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.endingNow();
    }

    public void outerSolvingEnded(SolverScope<Solution_> solverScope) {
        this.logger.info("Solving ended: time spent ({}), best score ({}), move evaluation speed ({}/sec), phase total ({}), environment mode ({}), move thread count ({}).", new Object[]{solverScope.getTimeMillisSpent(), solverScope.getBestScore().raw(), solverScope.getMoveEvaluationSpeed(), this.phaseList.size(), this.environmentMode.name(), this.moveThreadCountDescription});
        solverScope.getScoreDirector().close();
        this.solving.set(false);
    }

    private boolean checkProblemFactChanges() {
        boolean restartSolver = this.basicPlumbingTermination.waitForRestartSolverDecision();
        if (!restartSolver) {
            return false;
        }
        BlockingQueue<ProblemChangeAdapter<Solution_>> problemFactChangeQueue = this.basicPlumbingTermination.startProblemChangesProcessing();
        this.solverScope.setWorkingSolutionFromBestSolution();
        int stepIndex = 0;
        ProblemChangeAdapter problemChangeAdapter = (ProblemChangeAdapter)problemFactChangeQueue.poll();
        while (problemChangeAdapter != null) {
            problemChangeAdapter.doProblemChange(this.solverScope);
            this.logger.debug("    Real-time problem change applied; step index ({}).", (Object)stepIndex);
            ++stepIndex;
            problemChangeAdapter = (ProblemChangeAdapter)problemFactChangeQueue.poll();
        }
        InnerScoreDirector scoreDirector = this.solverScope.getScoreDirector();
        this.assertCorrectSolutionState();
        InnerScore score = scoreDirector.calculateScore();
        this.basicPlumbingTermination.endProblemChangesProcessing();
        this.bestSolutionRecaller.updateBestSolutionAndFireIfInitialized(this.solverScope);
        this.logger.info("Real-time problem fact changes done: step total ({}), new best score ({}).", (Object)stepIndex, score);
        return true;
    }
}

