/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.uni;

import ai.timefold.solver.core.api.score.stream.uni.UniConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.IntCalculator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class IntCalculatorUniCollector<A, Output_, Calculator_ extends IntCalculator<Output_>>
implements UniConstraintCollector<A, Calculator_, Output_> {
    private final ToIntFunction<? super A> mapper;

    public IntCalculatorUniCollector(ToIntFunction<? super A> mapper) {
        this.mapper = mapper;
    }

    @Override
    public @NonNull BiFunction<Calculator_, A, Runnable> accumulator() {
        return (calculator, a) -> {
            int mapped = this.mapper.applyAsInt(a);
            calculator.insert(mapped);
            return () -> calculator.retract(mapped);
        };
    }

    @Override
    public @Nullable Function<Calculator_, Output_> finisher() {
        return IntCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntCalculatorUniCollector that = (IntCalculatorUniCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

