/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.uni;

import ai.timefold.solver.core.api.score.stream.uni.UniConstraintCollector;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class ConditionalUniCollector<A, ResultContainer_, Result_>
implements UniConstraintCollector<A, ResultContainer_, Result_> {
    private final Predicate<A> predicate;
    private final UniConstraintCollector<A, ResultContainer_, Result_> delegate;
    private final BiFunction<ResultContainer_, A, Runnable> innerAccumulator;

    ConditionalUniCollector(Predicate<A> predicate, UniConstraintCollector<A, ResultContainer_, Result_> delegate) {
        this.predicate = predicate;
        this.delegate = delegate;
        this.innerAccumulator = delegate.accumulator();
    }

    @Override
    public @NonNull Supplier<ResultContainer_> supplier() {
        return this.delegate.supplier();
    }

    @Override
    public @NonNull BiFunction<ResultContainer_, A, Runnable> accumulator() {
        return (resultContainer, a) -> {
            if (this.predicate.test(a)) {
                return this.innerAccumulator.apply(resultContainer, a);
            }
            return ConstantLambdaUtils.noop();
        };
    }

    @Override
    public @Nullable Function<ResultContainer_, Result_> finisher() {
        return this.delegate.finisher();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionalUniCollector that = (ConditionalUniCollector)object;
        return Objects.equals(this.predicate, that.predicate) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.delegate);
    }
}

