/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ConnectedRangeImpl;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.RangeSplitPoint;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

final class ConnectedSubrangeIterator<Range_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements Iterator<ConnectedRangeImpl<Range_, Point_, Difference_>> {
    private final NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet;
    private final BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction;
    private final RangeSplitPoint<Range_, Point_> endSplitPoint;
    private RangeSplitPoint<Range_, Point_> current;

    public ConnectedSubrangeIterator(NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet, RangeSplitPoint<Range_, Point_> startSplitPoint, RangeSplitPoint<Range_, Point_> endSplitPoint, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction) {
        this.splitPointSet = splitPointSet;
        this.current = this.getStart(startSplitPoint);
        this.endSplitPoint = endSplitPoint;
        this.differenceFunction = differenceFunction;
    }

    private RangeSplitPoint<Range_, Point_> getStart(RangeSplitPoint<Range_, Point_> start) {
        while (start != null && start.isEmpty()) {
            start = this.splitPointSet.higher(start);
        }
        return start;
    }

    @Override
    public boolean hasNext() {
        return this.current != null && this.current.compareTo(this.endSplitPoint) <= 0 && !this.splitPointSet.isEmpty();
    }

    @Override
    public ConnectedRangeImpl<Range_, Point_, Difference_> next() {
        RangeSplitPoint<Range_, Point_> end;
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        RangeSplitPoint<Range_, Point_> start = this.current;
        int activeRangeCount = 0;
        int minimumOverlap = Integer.MAX_VALUE;
        int maximumOverlap = Integer.MIN_VALUE;
        int count = 0;
        boolean anyOverlap = false;
        do {
            count += this.current.rangesStartingAtSplitPointSet.size();
            if ((activeRangeCount += this.current.rangesStartingAtSplitPointSet.size() - this.current.rangesEndingAtSplitPointSet.size()) > 0) {
                minimumOverlap = Math.min(minimumOverlap, activeRangeCount);
                maximumOverlap = Math.max(maximumOverlap, activeRangeCount);
                if (activeRangeCount > 1) {
                    anyOverlap = true;
                }
            }
            this.current = this.splitPointSet.higher(this.current);
        } while (activeRangeCount > 0 && this.current != null);
        if (this.current != null) {
            end = this.splitPointSet.lower(this.current);
            this.current = this.getStart(this.current);
        } else {
            end = (RangeSplitPoint<Range_, Point_>)this.splitPointSet.last();
        }
        return new ConnectedRangeImpl<Range_, Point_, Difference_>(this.splitPointSet, this.differenceFunction, start, end, count, minimumOverlap, maximumOverlap, anyOverlap);
    }
}

