/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector;

import ai.timefold.solver.core.impl.score.stream.collector.UndoableActionable;
import ai.timefold.solver.core.impl.util.MutableInt;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

public final class SortedSetUndoableActionable<Mapped_>
implements UndoableActionable<Mapped_, SortedSet<Mapped_>> {
    private final NavigableMap<Mapped_, MutableInt> itemToCount;

    private SortedSetUndoableActionable(NavigableMap<Mapped_, MutableInt> itemToCount) {
        this.itemToCount = itemToCount;
    }

    public static <Result> SortedSetUndoableActionable<Result> orderBy(Comparator<? super Result> comparator) {
        return new SortedSetUndoableActionable<Result>(new TreeMap(comparator));
    }

    @Override
    public Runnable insert(Mapped_ result) {
        MutableInt count = this.itemToCount.computeIfAbsent(result, ignored -> new MutableInt());
        count.increment();
        return () -> {
            if (count.decrement() == 0) {
                this.itemToCount.remove(result);
            }
        };
    }

    @Override
    public NavigableSet<Mapped_> result() {
        return this.itemToCount.navigableKeySet();
    }
}

