/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector;

import ai.timefold.solver.core.impl.score.stream.collector.ObjectCalculator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

public final class ReferenceAverageCalculator<Input_, Output_>
implements ObjectCalculator<Input_, Output_, Input_> {
    int count = 0;
    Input_ sum;
    final BinaryOperator<Input_> adder;
    final BinaryOperator<Input_> subtractor;
    final BiFunction<Input_, Integer, Output_> divider;
    private static final Supplier<ReferenceAverageCalculator<BigDecimal, BigDecimal>> BIG_DECIMAL = () -> new ReferenceAverageCalculator<BigDecimal, BigDecimal>(BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract, (sum, count) -> sum.divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN));
    private static final Supplier<ReferenceAverageCalculator<BigInteger, BigDecimal>> BIG_INTEGER = () -> new ReferenceAverageCalculator<BigInteger, BigDecimal>(BigInteger.ZERO, BigInteger::add, BigInteger::subtract, (sum, count) -> new BigDecimal((BigInteger)sum).divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN));
    private static final Supplier<ReferenceAverageCalculator<Duration, Duration>> DURATION = () -> new ReferenceAverageCalculator<Duration, Duration>(Duration.ZERO, Duration::plus, Duration::minus, (sum, count) -> {
        long nanos = sum.toNanos();
        return Duration.ofNanos(nanos / (long)count.intValue());
    });

    public ReferenceAverageCalculator(Input_ zero, BinaryOperator<Input_> adder, BinaryOperator<Input_> subtractor, BiFunction<Input_, Integer, Output_> divider) {
        this.sum = zero;
        this.adder = adder;
        this.subtractor = subtractor;
        this.divider = divider;
    }

    public static Supplier<ReferenceAverageCalculator<BigDecimal, BigDecimal>> bigDecimal() {
        return BIG_DECIMAL;
    }

    public static Supplier<ReferenceAverageCalculator<BigInteger, BigDecimal>> bigInteger() {
        return BIG_INTEGER;
    }

    public static Supplier<ReferenceAverageCalculator<Duration, Duration>> duration() {
        return DURATION;
    }

    @Override
    public Input_ insert(Input_ input) {
        ++this.count;
        this.sum = this.adder.apply(this.sum, input);
        return input;
    }

    @Override
    public void retract(Input_ mapped) {
        --this.count;
        this.sum = this.subtractor.apply(this.sum, mapped);
    }

    @Override
    public Output_ result() {
        if (this.count == 0) {
            return null;
        }
        return this.divider.apply(this.sum, this.count);
    }
}

