/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.stream;

import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

record DefaultConstraintMetaModel(Map<ConstraintRef, Constraint> constraintPerRefMap, Map<String, List<Constraint>> constraintPerGroupMap) implements ConstraintMetaModel
{
    public static ConstraintMetaModel of(List<? extends Constraint> constraints) {
        int constraintCount = constraints.size();
        Map<ConstraintRef, Constraint> perRefMap = CollectionUtils.newLinkedHashMap(constraintCount);
        TreeMap<String, List> perGroupMap = new TreeMap<String, List>();
        for (Constraint constraint : constraints) {
            perRefMap.put(constraint.getConstraintRef(), constraint);
            perGroupMap.computeIfAbsent(constraint.getConstraintGroup(), k -> new ArrayList(constraintCount)).add(constraint);
        }
        return new DefaultConstraintMetaModel(Collections.unmodifiableMap(perRefMap), Collections.unmodifiableMap(perGroupMap));
    }

    @Override
    public @Nullable Constraint getConstraint(@NonNull ConstraintRef constraintRef) {
        return this.constraintPerRefMap.get(constraintRef);
    }

    @Override
    public @NonNull Collection<Constraint> getConstraintsPerGroup(@NonNull String constraintGroup) {
        return this.constraintPerGroupMap.getOrDefault(constraintGroup, Collections.emptyList());
    }

    @Override
    public @NonNull Set<String> getConstraintGroups() {
        return this.constraintPerGroupMap.keySet();
    }

    @Override
    public @NonNull Collection<Constraint> getConstraints() {
        return this.constraintPerRefMap.values();
    }
}

