/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.incremental;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.incremental.IncrementalScoreDirector;
import java.util.function.Supplier;

public final class IncrementalScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirectorFactory<Solution_, Score_, IncrementalScoreDirectorFactory<Solution_, Score_>> {
    private final Supplier<IncrementalScoreCalculator<Solution_, Score_>> incrementalScoreCalculatorSupplier;

    public static <Solution_, Score_ extends Score<Score_>> IncrementalScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config) {
        if (!IncrementalScoreCalculator.class.isAssignableFrom(config.getIncrementalScoreCalculatorClass())) {
            throw new IllegalArgumentException("The incrementalScoreCalculatorClass (%s) does not implement %s.".formatted(config.getIncrementalScoreCalculatorClass(), IncrementalScoreCalculator.class.getSimpleName()));
        }
        return new IncrementalScoreDirectorFactory<Solution_, Score_>(solutionDescriptor, () -> {
            IncrementalScoreCalculator incrementalScoreCalculator = ConfigUtils.newInstance(config, "incrementalScoreCalculatorClass", config.getIncrementalScoreCalculatorClass());
            ConfigUtils.applyCustomProperties(incrementalScoreCalculator, "incrementalScoreCalculatorClass", config.getIncrementalScoreCalculatorCustomProperties(), "incrementalScoreCalculatorCustomProperties");
            return incrementalScoreCalculator;
        });
    }

    public IncrementalScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, Supplier<IncrementalScoreCalculator<Solution_, Score_>> incrementalScoreCalculatorSupplier) {
        super(solutionDescriptor);
        this.incrementalScoreCalculatorSupplier = incrementalScoreCalculatorSupplier;
    }

    @Override
    public boolean supportsConstraintMatching() {
        return this.incrementalScoreCalculatorSupplier.get() instanceof ConstraintMatchAwareIncrementalScoreCalculator;
    }

    public IncrementalScoreDirector.Builder<Solution_, Score_> createScoreDirectorBuilder() {
        return new IncrementalScoreDirector.Builder<Solution_, Score_>(this).withIncrementalScoreCalculator(this.incrementalScoreCalculatorSupplier.get());
    }

    public IncrementalScoreDirector<Solution_, Score_> buildScoreDirector() {
        return ((IncrementalScoreDirector.Builder)this.createScoreDirectorBuilder()).build();
    }
}

