/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.provider;

import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.move.streams.maybeapi.DataJoiners;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.SwapMove;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.provider.UniquePair;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProducer;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProvider;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamFactory;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SwapMoveProvider<Solution_, Entity_>
implements MoveProvider<Solution_> {
    private final PlanningEntityMetaModel<Solution_, Entity_> entityMetaModel;
    private final List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModelList;

    public SwapMoveProvider(PlanningEntityMetaModel<Solution_, Entity_> entityMetaModel) {
        this.entityMetaModel = Objects.requireNonNull(entityMetaModel);
        this.variableMetaModelList = entityMetaModel.variables().stream().flatMap(v -> {
            if (v instanceof PlanningVariableMetaModel) {
                PlanningVariableMetaModel planningVariableMetaModel = (PlanningVariableMetaModel)v;
                return Stream.of(planningVariableMetaModel);
            }
            return Stream.empty();
        }).toList();
        if (this.variableMetaModelList.isEmpty()) {
            throw new IllegalArgumentException("The entityClass (%s) has no basic planning variables.".formatted(entityMetaModel.type().getCanonicalName()));
        }
    }

    public SwapMoveProvider(List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModelList) {
        this.variableMetaModelList = Objects.requireNonNull(variableMetaModelList);
        List<PlanningEntityMetaModel> entityMetaModels = variableMetaModelList.stream().map(VariableMetaModel::entity).distinct().toList();
        switch (entityMetaModels.size()) {
            case 0: {
                throw new IllegalArgumentException("The variableMetaModelList (%s) is empty.".formatted(variableMetaModelList));
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The variableMetaModelList (%s) contains variables from multiple entity classes.".formatted(variableMetaModelList));
            }
        }
        this.entityMetaModel = entityMetaModels.get(0);
    }

    @Override
    public MoveProducer<Solution_> apply(MoveStreamFactory<Solution_> moveStreamFactory) {
        Class<Entity_> entityType = this.entityMetaModel.type();
        BiDataStream<Solution_, Object, Object> dataStream = moveStreamFactory.enumerate(entityType, false).join(entityType, DataJoiners.filtering((solutionView, leftEntity, rightEntity) -> {
            if (leftEntity == rightEntity) {
                return false;
            }
            boolean change = false;
            for (PlanningVariableMetaModel<Solution_, Entity_, Object> variableMetaModel : this.variableMetaModelList) {
                Object oldRightValue;
                DefaultPlanningVariableMetaModel defaultVariableMetaModel = (DefaultPlanningVariableMetaModel)variableMetaModel;
                GenuineVariableDescriptor variableDescriptor = defaultVariableMetaModel.variableDescriptor();
                Object oldLeftValue = variableDescriptor.getValue(leftEntity);
                if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(rightEntity))) continue;
                if (solutionView.isValueInRange(variableMetaModel, leftEntity, oldRightValue) && solutionView.isValueInRange(variableMetaModel, rightEntity, oldLeftValue)) {
                    change = true;
                    continue;
                }
                return false;
            }
            return change;
        })).map((solutionView, leftEntity, rightEntity) -> new UniquePair<Object>(leftEntity, rightEntity)).distinct().map((solutionView, pair) -> pair.first(), (solutionView, pair) -> pair.second());
        return moveStreamFactory.pick(dataStream).asMove((solutionView, leftEntity, rightEntity) -> new SwapMove<Solution_, Object>(this.variableMetaModelList, leftEntity, rightEntity));
    }
}

