/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move;

import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ListSwapMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final Entity_ leftEntity;
    private final int leftIndex;
    private final Entity_ rightEntity;
    private final int rightIndex;
    private @Nullable Value_ leftValue;
    private @Nullable Value_ rightValue;

    public ListSwapMove(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ leftEntity, int leftIndex, Entity_ rightEntity, int rightIndex) {
        this.variableMetaModel = variableMetaModel;
        this.leftEntity = leftEntity;
        this.leftIndex = leftIndex;
        this.rightEntity = rightEntity;
        this.rightIndex = rightIndex;
    }

    public Entity_ getLeftEntity() {
        return this.leftEntity;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public Entity_ getRightEntity() {
        return this.rightEntity;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    private Value_ getLeftValueCache() {
        if (this.leftValue == null) {
            this.leftValue = ListSwapMove.getVariableDescriptor(this.variableMetaModel).getElement(this.leftEntity, this.leftIndex);
        }
        return this.leftValue;
    }

    private Value_ getRightValueCache() {
        if (this.rightValue == null) {
            this.rightValue = ListSwapMove.getVariableDescriptor(this.variableMetaModel).getElement(this.rightEntity, this.rightIndex);
        }
        return this.rightValue;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        solutionView.swapValuesBetweenLists(this.variableMetaModel, this.leftEntity, this.leftIndex, this.rightEntity, this.rightIndex);
    }

    public ListSwapMove<Solution_, Entity_, Value_> rebase(Rebaser rebaser) {
        return new ListSwapMove<Solution_, Entity_, Value_>(this.variableMetaModel, rebaser.rebase(this.leftEntity), this.leftIndex, rebaser.rebase(this.rightEntity), this.rightIndex);
    }

    @Override
    public List<PlanningListVariableMetaModel<Solution_, Entity_, Value_>> variableMetaModels() {
        return Collections.singletonList(this.variableMetaModel);
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        return this.leftEntity == this.rightEntity ? Collections.singleton(this.leftEntity) : Arrays.asList(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<Value_> extractPlanningValues() {
        return Arrays.asList(this.getLeftValueCache(), this.getRightValueCache());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ListSwapMove)) return false;
        ListSwapMove other = (ListSwapMove)o;
        if (!Objects.equals(this.variableMetaModel, other.variableMetaModel)) return false;
        if (!Objects.equals(this.leftEntity, other.leftEntity)) return false;
        if (this.leftIndex != other.leftIndex) return false;
        if (!Objects.equals(this.rightEntity, other.rightEntity)) return false;
        if (this.rightIndex != other.rightIndex) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.leftEntity, this.leftIndex, this.rightEntity, this.rightIndex);
    }

    @Override
    public String toString() {
        return String.format("%s {%s[%d]} <-> %s {%s[%d]}", this.getLeftValueCache(), this.leftEntity, this.leftIndex, this.getRightValueCache(), this.rightEntity, this.rightIndex);
    }
}

