/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset.bi;

import ai.timefold.solver.core.impl.bavet.bi.IndexedJoinBiNode;
import ai.timefold.solver.core.impl.bavet.bi.UnindexedJoinBiNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.bi.AbstractBiDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.move.streams.dataset.common.JoinDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.bridge.ForeBridgeUniDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.joiner.DefaultBiDataJoiner;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataFilter;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public final class JoinBiDataStream<Solution_, A, B>
extends AbstractBiDataStream<Solution_, A, B>
implements JoinDataStream<Solution_> {
    private final ForeBridgeUniDataStream<Solution_, A> leftParent;
    private final ForeBridgeUniDataStream<Solution_, B> rightParent;
    private final DefaultBiDataJoiner<A, B> joiner;
    private final BiDataFilter<Solution_, A, B> filtering;

    public JoinBiDataStream(DataStreamFactory<Solution_> dataStreamFactory, ForeBridgeUniDataStream<Solution_, A> leftParent, ForeBridgeUniDataStream<Solution_, B> rightParent, DefaultBiDataJoiner<A, B> joiner, BiDataFilter<Solution_, A, B> filtering) {
        super(dataStreamFactory);
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> dataStreamSet) {
        this.leftParent.collectActiveDataStreams(dataStreamSet);
        this.rightParent.collectActiveDataStreams(dataStreamSet);
        dataStreamSet.add(this);
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        SolutionView<Solution_> solutionView = buildHelper.getSessionContext().solutionView();
        BiPredicate<A, B> filteringDataJoiner = this.filtering == null ? null : this.filtering.toBiPredicate(solutionView);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory<B> indexerFactory = new IndexerFactory<B>(this.joiner.toBiJoiner());
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinBiNode(indexerFactory, buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, filteringDataJoiner, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1) : new UnindexedJoinBiNode(buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, filteringDataJoiner, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof JoinBiDataStream)) return false;
        JoinBiDataStream other = (JoinBiDataStream)o;
        if (!Objects.equals(this.leftParent.getParent(), other.leftParent.getParent())) return false;
        if (!Objects.equals(this.rightParent.getParent(), other.rightParent.getParent())) return false;
        if (!Objects.equals(this.joiner, other.joiner)) return false;
        if (!Objects.equals(this.filtering, other.filtering)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent(), this.joiner, this.filtering);
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }

    @Override
    public AbstractDataStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public AbstractDataStream<Solution_> getRightParent() {
        return this.rightParent;
    }
}

