/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset;

import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractNodeBuildHelper;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetSession;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDataset;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDatasetInstance;
import ai.timefold.solver.core.impl.move.streams.dataset.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class DatasetSessionFactory<Solution_> {
    private final DataStreamFactory<Solution_> dataStreamFactory;

    public DatasetSessionFactory(DataStreamFactory<Solution_> dataStreamFactory) {
        this.dataStreamFactory = dataStreamFactory;
    }

    public DatasetSession<Solution_> buildSession(SessionContext<Solution_> context) {
        LinkedHashSet activeDataStreamSet = new LinkedHashSet();
        List<AbstractDataset<Solution_, ?>> datasets = this.dataStreamFactory.getDatasets();
        for (AbstractDataset dataset : datasets) {
            dataset.collectActiveDataStreams(activeDataStreamSet);
        }
        DataNodeBuildHelper<Solution_> buildHelper = new DataNodeBuildHelper<Solution_>(context, activeDataStreamSet);
        DatasetSession<Solution_> session = new DatasetSession<Solution_>(this.buildNodeNetwork(activeDataStreamSet, buildHelper, null));
        for (AbstractDatasetInstance<Solution_, ?> datasetInstance : buildHelper.getDatasetInstanceList()) {
            session.registerDatasetInstance(datasetInstance.getParent(), datasetInstance);
        }
        return session;
    }

    private NodeNetwork buildNodeNetwork(Set<AbstractDataStream<Solution_>> dataStreamSet, DataNodeBuildHelper<Solution_> buildHelper, Consumer<String> nodeNetworkVisualizationConsumer) {
        LinkedHashMap declaredClassToNodeMap = new LinkedHashMap();
        List<AbstractNode> nodeList = buildHelper.buildNodeList(dataStreamSet, buildHelper, AbstractDataStream::buildNode, node -> {
            if (!(node instanceof AbstractForEachUniNode)) {
                return;
            }
            AbstractForEachUniNode forEachUniNode = (AbstractForEachUniNode)node;
            Class forEachClass = forEachUniNode.getForEachClass();
            List forEachUniNodeList = declaredClassToNodeMap.computeIfAbsent(forEachClass, k -> new ArrayList(2));
            if (forEachUniNodeList.size() == 2) {
                throw new IllegalStateException("Impossible state: For class (%s) there are already 2 nodes (%s), not adding another (%s).".formatted(forEachClass, forEachUniNodeList, forEachUniNode));
            }
            forEachUniNodeList.add(forEachUniNode);
        });
        if (nodeNetworkVisualizationConsumer != null) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        return AbstractNodeBuildHelper.buildNodeNetwork(nodeList, declaredClassToNodeMap);
    }
}

