/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams;

import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.move.streams.DefaultMoveStreamSession;
import ai.timefold.solver.core.impl.move.streams.InnerMoveProducer;
import ai.timefold.solver.core.impl.move.streams.MoveIterable;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.uni.UniDataset;
import ai.timefold.solver.core.impl.move.streams.dataset.uni.UniDatasetInstance;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiMoveConstructor;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamSession;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FromUniBiMoveProducer<Solution_, A, B>
implements InnerMoveProducer<Solution_> {
    private final UniDataset<Solution_, A> aDataset;
    private final UniDataset<Solution_, B> bDataset;
    private final BiMoveConstructor<Solution_, A, B> moveConstructor;
    private final BiPredicate<A, B> filter;

    public FromUniBiMoveProducer(UniDataset<Solution_, A> aDataset, UniDataset<Solution_, B> bDataset, BiPredicate<A, B> filter, BiMoveConstructor<Solution_, A, B> moveConstructor) {
        this.aDataset = Objects.requireNonNull(aDataset);
        this.bDataset = Objects.requireNonNull(bDataset);
        this.filter = Objects.requireNonNull(filter);
        this.moveConstructor = Objects.requireNonNull(moveConstructor);
    }

    @Override
    public MoveIterable<Solution_> getMoveIterable(MoveStreamSession<Solution_> moveStreamSession) {
        return new BiMoveIterable((DefaultMoveStreamSession)moveStreamSession);
    }

    @Override
    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> activeDataStreamSet) {
        this.aDataset.collectActiveDataStreams(activeDataStreamSet);
        this.bDataset.collectActiveDataStreams(activeDataStreamSet);
    }

    private final class BiMoveIterable
    implements MoveIterable<Solution_> {
        private final DefaultMoveStreamSession<Solution_> moveStreamSession;

        public BiMoveIterable(DefaultMoveStreamSession<Solution_> moveStreamSession) {
            this.moveStreamSession = Objects.requireNonNull(moveStreamSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator() {
            return new BiMoveIterator(this.moveStreamSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator(Random random) {
            return new BiMoveIterator(this.moveStreamSession, random);
        }
    }

    private final class BiMoveIterator
    implements Iterator<Move<Solution_>> {
        private final IteratorSupplier<A> aIteratorSupplier;
        private final IteratorSupplier<B> bIteratorSupplier;
        private final SolutionView<Solution_> solutionView;
        private @Nullable Move<Solution_> nextMove;
        private @Nullable Iterator<UniTuple<A>> aIterator;
        private @Nullable Iterator<UniTuple<B>> bIterator;
        private @Nullable A currentA;

        public BiMoveIterator(DefaultMoveStreamSession<Solution_> moveStreamSession) {
            UniDatasetInstance aInstance = moveStreamSession.getDatasetInstance(FromUniBiMoveProducer.this.aDataset);
            this.aIteratorSupplier = aInstance::iterator;
            UniDatasetInstance bInstance = moveStreamSession.getDatasetInstance(FromUniBiMoveProducer.this.bDataset);
            this.bIteratorSupplier = bInstance::iterator;
            this.solutionView = moveStreamSession.getSolutionView();
        }

        public BiMoveIterator(DefaultMoveStreamSession<Solution_> moveStreamSession, Random random) {
            UniDatasetInstance aInstance = moveStreamSession.getDatasetInstance(FromUniBiMoveProducer.this.aDataset);
            this.aIteratorSupplier = () -> aInstance.iterator(random);
            UniDatasetInstance bInstance = moveStreamSession.getDatasetInstance(FromUniBiMoveProducer.this.bDataset);
            this.bIteratorSupplier = () -> bInstance.iterator(random);
            this.solutionView = moveStreamSession.getSolutionView();
        }

        @Override
        public boolean hasNext() {
            if (this.nextMove != null) {
                return true;
            }
            if (this.aIterator == null) {
                this.aIterator = (Iterator)this.aIteratorSupplier.get();
                if (!this.aIterator.hasNext()) {
                    return false;
                }
                this.currentA = this.aIterator.next().factA;
                this.bIterator = (Iterator)this.bIteratorSupplier.get();
            }
            while (true) {
                if (this.bIterator.hasNext()) {
                    UniTuple bTuple = this.bIterator.next();
                    Object currentB = bTuple.factA;
                    if (!FromUniBiMoveProducer.this.filter.test(this.currentA, currentB)) continue;
                    this.nextMove = FromUniBiMoveProducer.this.moveConstructor.apply(this.solutionView, this.currentA, currentB);
                    return true;
                }
                if (!this.aIterator.hasNext()) break;
                this.currentA = this.aIterator.next().factA;
                this.bIterator = (Iterator)this.bIteratorSupplier.get();
            }
            return false;
        }

        @Override
        public Move<Solution_> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Move result = this.nextMove;
            this.nextMove = null;
            return result;
        }

        @FunctionalInterface
        private static interface IteratorSupplier<A>
        extends Supplier<Iterator<UniTuple<A>>> {
        }
    }
}

