/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams;

import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.move.streams.DefaultMoveStreamSession;
import ai.timefold.solver.core.impl.move.streams.InnerMoveProducer;
import ai.timefold.solver.core.impl.move.streams.MoveIterable;
import ai.timefold.solver.core.impl.move.streams.dataset.bi.BiDataset;
import ai.timefold.solver.core.impl.move.streams.dataset.bi.BiDatasetInstance;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiMoveConstructor;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamSession;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FromBiUniMoveProducer<Solution_, A, B>
implements InnerMoveProducer<Solution_> {
    private final BiDataset<Solution_, A, B> aDataset;
    private final BiMoveConstructor<Solution_, A, B> moveConstructor;

    public FromBiUniMoveProducer(BiDataset<Solution_, A, B> aDataset, BiMoveConstructor<Solution_, A, B> moveConstructor) {
        this.aDataset = Objects.requireNonNull(aDataset);
        this.moveConstructor = Objects.requireNonNull(moveConstructor);
    }

    @Override
    public MoveIterable<Solution_> getMoveIterable(MoveStreamSession<Solution_> moveStreamSession) {
        return new InnerMoveIterable((DefaultMoveStreamSession)moveStreamSession);
    }

    @Override
    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> activeDataStreamSet) {
        this.aDataset.collectActiveDataStreams(activeDataStreamSet);
    }

    @NullMarked
    private final class InnerMoveIterable
    implements MoveIterable<Solution_> {
        private final DefaultMoveStreamSession<Solution_> moveStreamSession;

        public InnerMoveIterable(DefaultMoveStreamSession<Solution_> moveStreamSession) {
            this.moveStreamSession = Objects.requireNonNull(moveStreamSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator() {
            return new InnerMoveIterator(this.moveStreamSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator(Random random) {
            return new InnerMoveIterator(this.moveStreamSession, random);
        }
    }

    @NullMarked
    private final class InnerMoveIterator
    implements Iterator<Move<Solution_>> {
        private final IteratorSupplier<A, B> iteratorSupplier;
        private final SolutionView<Solution_> solutionView;
        private @Nullable Move<Solution_> nextMove;
        private @Nullable Iterator<BiTuple<A, B>> iterator;

        public InnerMoveIterator(DefaultMoveStreamSession<Solution_> moveStreamSession) {
            BiDatasetInstance aInstance = moveStreamSession.getDatasetInstance(FromBiUniMoveProducer.this.aDataset);
            this.iteratorSupplier = aInstance::iterator;
            this.solutionView = moveStreamSession.getSolutionView();
        }

        public InnerMoveIterator(DefaultMoveStreamSession<Solution_> moveStreamSession, Random random) {
            BiDatasetInstance aInstance = moveStreamSession.getDatasetInstance(FromBiUniMoveProducer.this.aDataset);
            this.iteratorSupplier = () -> aInstance.iterator(random);
            this.solutionView = moveStreamSession.getSolutionView();
        }

        @Override
        public boolean hasNext() {
            if (this.nextMove != null) {
                return true;
            }
            if (this.iterator == null) {
                this.iterator = (Iterator)this.iteratorSupplier.get();
            }
            if (!this.iterator.hasNext()) {
                return false;
            }
            BiTuple tuple = this.iterator.next();
            this.nextMove = FromBiUniMoveProducer.this.moveConstructor.apply(this.solutionView, tuple.factA, tuple.factB);
            return true;
        }

        @Override
        public Move<Solution_> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Move result = this.nextMove;
            this.nextMove = null;
            return result;
        }

        @FunctionalInterface
        private static interface IteratorSupplier<A, B>
        extends Supplier<Iterator<BiTuple<A, B>>> {
        }
    }
}

