/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move;

import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.constructionheuristic.placer.QueuedValuePlacer;
import ai.timefold.solver.core.impl.move.MoveRepository;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PlacerBasedMoveRepository<Solution_>
implements MoveRepository<Solution_> {
    private final EntityPlacer<Solution_> placer;
    private @Nullable Iterator<Placement<Solution_>> placementIterator;

    public PlacerBasedMoveRepository(EntityPlacer<Solution_> placer) {
        this.placer = Objects.requireNonNull(placer);
    }

    public EntityPlacer<Solution_> getPlacer() {
        return this.placer;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public void initialize(SessionContext<Solution_> context) {
        this.placementIterator = this.placer.iterator();
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.placer.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.placer.phaseStarted(phaseScope);
        phaseScope.getScoreDirector().setMoveRepository(this);
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        this.placer.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        this.placer.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        phaseScope.getScoreDirector().setMoveRepository(null);
        this.placer.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.placer.solvingEnded(solverScope);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return Objects.requireNonNull(this.placementIterator).next().iterator();
    }

    public boolean hasNext() {
        return Objects.requireNonNull(this.placementIterator).hasNext();
    }

    public boolean hasListVariable() {
        QueuedValuePlacer queuedValuePlacer;
        EntityPlacer<Solution_> entityPlacer = this.placer;
        return entityPlacer instanceof QueuedValuePlacer && (queuedValuePlacer = (QueuedValuePlacer)entityPlacer).hasListChangeMoveSelector();
    }
}

