/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.pillar.PillarSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.PillarSwapMoveSelector;
import java.util.List;
import java.util.Objects;

public class PillarSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, PillarSwapMoveSelectorConfig> {
    public PillarSwapMoveSelectorFactory(PillarSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        List<String> rightVariableNameIncludeList;
        PillarSelectorConfig rightPillarSelectorConfig;
        List<String> leftVariableNameIncludeList;
        PillarSelectorConfig leftPillarSelectorConfig = Objects.requireNonNullElseGet(((PillarSwapMoveSelectorConfig)this.config).getPillarSelectorConfig(), PillarSelectorConfig::new);
        EntityDescriptor<Solution_> leftEntityDescriptor = null;
        EntitySelectorConfig leftEntitySelectorConfig = leftPillarSelectorConfig.getEntitySelectorConfig();
        if (leftEntitySelectorConfig != null && leftEntitySelectorConfig.getEntityClass() != null) {
            leftEntityDescriptor = configPolicy.getSolutionDescriptor().findEntityDescriptor(leftEntitySelectorConfig.getEntityClass());
        }
        if ((leftVariableNameIncludeList = ((PillarSwapMoveSelectorConfig)this.config).getVariableNameIncludeList()) == null && leftEntityDescriptor != null && leftEntityDescriptor.hasAnyGenuineBasicVariables() && leftEntityDescriptor.hasAnyGenuineListVariables()) {
            leftVariableNameIncludeList = leftEntityDescriptor.getGenuineBasicVariableDescriptorList().stream().map(VariableDescriptor::getVariableName).toList();
        }
        if ((rightPillarSelectorConfig = ((PillarSwapMoveSelectorConfig)this.config).getSecondaryPillarSelectorConfig()) == null) {
            rightPillarSelectorConfig = leftPillarSelectorConfig;
        }
        EntityDescriptor<Solution_> rightEntityDescriptor = null;
        EntitySelectorConfig rightEntitySelectorConfig = rightPillarSelectorConfig.getEntitySelectorConfig();
        if (rightEntitySelectorConfig != null && rightEntitySelectorConfig.getEntityClass() != null) {
            rightEntityDescriptor = configPolicy.getSolutionDescriptor().findEntityDescriptor(rightEntitySelectorConfig.getEntityClass());
        }
        if ((rightVariableNameIncludeList = ((PillarSwapMoveSelectorConfig)this.config).getVariableNameIncludeList()) == null && rightEntityDescriptor != null && rightEntityDescriptor.hasAnyGenuineBasicVariables() && rightEntityDescriptor.hasAnyGenuineListVariables()) {
            rightVariableNameIncludeList = rightEntityDescriptor.getGenuineBasicVariableDescriptorList().stream().map(VariableDescriptor::getVariableName).toList();
        }
        PillarSelector<Solution_> leftPillarSelector = this.buildPillarSelector(leftPillarSelectorConfig, configPolicy, leftVariableNameIncludeList, minimumCacheType, randomSelection);
        PillarSelector<Solution_> rightPillarSelector = this.buildPillarSelector(rightPillarSelectorConfig, configPolicy, rightVariableNameIncludeList, minimumCacheType, randomSelection);
        List<GenuineVariableDescriptor<Solution_>> variableDescriptorList = this.deduceVariableDescriptorList(leftPillarSelector.getEntityDescriptor(), leftVariableNameIncludeList);
        return new PillarSwapMoveSelector<Solution_>(leftPillarSelector, rightPillarSelector, variableDescriptorList, randomSelection);
    }

    private PillarSelector<Solution_> buildPillarSelector(PillarSelectorConfig pillarSelectorConfig, HeuristicConfigPolicy<Solution_> configPolicy, List<String> variableNameIncludeList, SelectionCacheType minimumCacheType, boolean randomSelection) {
        return PillarSelectorFactory.create(pillarSelectorConfig).buildPillarSelector(configPolicy, ((PillarSwapMoveSelectorConfig)this.config).getSubPillarType(), ((PillarSwapMoveSelectorConfig)this.config).getSubPillarSequenceComparatorClass(), minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection), variableNameIncludeList);
    }
}

