/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import java.util.Iterator;

public final class FilteringMoveSelector<Solution_>
extends AbstractMoveSelector<Solution_> {
    private static final long BAIL_OUT_MULTIPLIER = 10L;
    private final MoveSelector<Solution_> childMoveSelector;
    private final SelectionFilter<Solution_, Move<Solution_>> filter;
    private final boolean bailOutEnabled;
    private AbstractPhaseScope<Solution_> phaseScope;
    private ScoreDirector<Solution_> scoreDirector = null;

    public static <Solution_> FilteringMoveSelector<Solution_> of(MoveSelector<Solution_> moveSelector, SelectionFilter<Solution_, Move<Solution_>> filter) {
        if (moveSelector instanceof FilteringMoveSelector) {
            FilteringMoveSelector filteringMoveSelector = (FilteringMoveSelector)moveSelector;
            return new FilteringMoveSelector<Solution_>(filteringMoveSelector.childMoveSelector, SelectionFilter.compose(filteringMoveSelector.filter, filter));
        }
        return new FilteringMoveSelector<Solution_>(moveSelector, filter);
    }

    private FilteringMoveSelector(MoveSelector<Solution_> childMoveSelector, SelectionFilter<Solution_, Move<Solution_>> filter) {
        this.childMoveSelector = childMoveSelector;
        this.filter = filter;
        this.bailOutEnabled = childMoveSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
        this.phaseScope = phaseScope;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
        this.phaseScope = null;
    }

    @Override
    public boolean isCountable() {
        return this.childMoveSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childMoveSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childMoveSelector.getSize();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new JustInTimeFilteringMoveIterator(this.childMoveSelector.iterator(), this.determineBailOutSize(), this.phaseScope);
    }

    private long determineBailOutSize() {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        try {
            return this.childMoveSelector.getSize() * 10L;
        }
        catch (Exception ex) {
            long bailOutSize = 327670L;
            this.logger.trace("        Never-ending move selector ({}) failed to provide size, choosing a bail-out size of ({}) attempts.", this.childMoveSelector, (Object)bailOutSize);
            return bailOutSize;
        }
    }

    private boolean accept(ScoreDirector<Solution_> scoreDirector, Move<Solution_> move) {
        if (this.filter != null && !this.filter.accept(scoreDirector, move)) {
            this.logger.trace("        Move ({}) filtered out by a selection filter ({}).", move, this.filter);
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + String.valueOf(this.childMoveSelector) + ")";
    }

    private class JustInTimeFilteringMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private final long TERMINATION_BAIL_OUT_SIZE = 1000L;
        private final Iterator<Move<Solution_>> childMoveIterator;
        private final long bailOutSize;
        private final AbstractPhaseScope<Solution_> phaseScope;
        private final PhaseTermination<Solution_> termination;

        public JustInTimeFilteringMoveIterator(Iterator<Move<Solution_>> childMoveIterator, long bailOutSize, AbstractPhaseScope<Solution_> phaseScope) {
            this.childMoveIterator = childMoveIterator;
            this.bailOutSize = bailOutSize;
            this.phaseScope = phaseScope;
            this.termination = phaseScope != null ? phaseScope.getTermination() : null;
        }

        @Override
        protected Move<Solution_> createUpcomingSelection() {
            Move next;
            long attemptsBeforeBailOut = this.bailOutSize;
            long attemptsBeforeCheckTermination = 1000L;
            do {
                if (!this.childMoveIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                if (!FilteringMoveSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringMoveSelector.this.logger.trace("Bailing out of neverEnding selector ({}) after ({}) attempts to avoid infinite loop.", (Object)FilteringMoveSelector.this, (Object)this.bailOutSize);
                    return (Move)this.noUpcomingSelection();
                }
                if (this.termination != null && attemptsBeforeCheckTermination <= 0L) {
                    attemptsBeforeCheckTermination = 1000L;
                    if (this.termination.isPhaseTerminated(this.phaseScope)) {
                        FilteringMoveSelector.this.logger.trace("Bailing out of neverEnding selector ({}) because the termination setting has been triggered.", (Object)FilteringMoveSelector.this);
                        return (Move)this.noUpcomingSelection();
                    }
                }
                --attemptsBeforeBailOut;
                --attemptsBeforeCheckTermination;
            } while (!FilteringMoveSelector.this.accept(FilteringMoveSelector.this.scoreDirector, next = this.childMoveIterator.next()));
            return next;
        }
    }
}

