/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.composite;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.NearbyAutoConfigurationEnabled;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.AbstractCompositeMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.FixedSelectorProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.UnionMoveSelector;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class UnionMoveSelectorFactory<Solution_>
extends AbstractCompositeMoveSelectorFactory<Solution_, UnionMoveSelectorConfig> {
    public UnionMoveSelectorFactory(UnionMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        FixedSelectorProbabilityWeightFactory selectorProbabilityWeightFactory;
        LinkedList<MoveSelectorConfig> moveSelectorConfigList = new LinkedList<MoveSelectorConfig>(((UnionMoveSelectorConfig)this.config).getMoveSelectorList());
        if (configPolicy.getNearbyDistanceMeterClass() != null) {
            boolean isMixedModel = configPolicy.getSolutionDescriptor().hasBothBasicAndListVariables();
            for (MoveSelectorConfig selectorConfig : ((UnionMoveSelectorConfig)this.config).getMoveSelectorList()) {
                boolean isNearbyDisabled;
                if (!(selectorConfig instanceof NearbyAutoConfigurationEnabled)) continue;
                NearbyAutoConfigurationEnabled nearbySelectorConfig = (NearbyAutoConfigurationEnabled)((Object)selectorConfig);
                if (selectorConfig.hasNearbySelectionConfig()) {
                    throw new IllegalArgumentException("The selector configuration (%s) already includes the Nearby Selection setting, making it incompatible with the top-level property nearbyDistanceMeterClass (%s).\nRemove the Nearby setting from the selector configuration or remove the top-level nearbyDistanceMeterClass.".formatted(nearbySelectorConfig, configPolicy.getNearbyDistanceMeterClass()));
                }
                boolean isUnionMoveSelectorConfig = selectorConfig instanceof UnionMoveSelectorConfig;
                boolean bl = isNearbyDisabled = isMixedModel && !nearbySelectorConfig.canEnableNearbyInMixedModels();
                if (isUnionMoveSelectorConfig || isNearbyDisabled) continue;
                moveSelectorConfigList.add((MoveSelectorConfig)nearbySelectorConfig.enableNearbySelection(configPolicy.getNearbyDistanceMeterClass(), configPolicy.getRandom()));
            }
        }
        List<MoveSelector<Solution_>> moveSelectorList = this.buildInnerMoveSelectors(moveSelectorConfigList, configPolicy, minimumCacheType, randomSelection);
        Class<? extends SelectionProbabilityWeightFactory> selectorProbabilityWeightFactoryClass = ((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass();
        if (selectorProbabilityWeightFactoryClass != null) {
            if (!randomSelection) {
                throw new IllegalArgumentException("The moveSelectorConfig (%s) with selectorProbabilityWeightFactoryClass (%s) has non-random randomSelection (%s).".formatted(configPolicy, selectorProbabilityWeightFactoryClass, randomSelection));
            }
            selectorProbabilityWeightFactory = ConfigUtils.newInstance(this.config, "selectorProbabilityWeightFactoryClass", selectorProbabilityWeightFactoryClass);
        } else if (randomSelection) {
            HashMap<MoveSelector<Solution_>, Double> fixedProbabilityWeightMap = new HashMap<MoveSelector<Solution_>, Double>(moveSelectorConfigList.size());
            for (int i = 0; i < moveSelectorConfigList.size(); ++i) {
                MoveSelectorConfig innerMoveSelectorConfig = moveSelectorConfigList.get(i);
                MoveSelector<Solution_> moveSelector = moveSelectorList.get(i);
                Double fixedProbabilityWeight = innerMoveSelectorConfig.getFixedProbabilityWeight();
                if (fixedProbabilityWeight == null) continue;
                fixedProbabilityWeightMap.put(moveSelector, fixedProbabilityWeight);
            }
            selectorProbabilityWeightFactory = fixedProbabilityWeightMap.isEmpty() ? null : new FixedSelectorProbabilityWeightFactory(fixedProbabilityWeightMap);
        } else {
            selectorProbabilityWeightFactory = null;
        }
        return new UnionMoveSelector<Solution_>(moveSelectorList, randomSelection, selectorProbabilityWeightFactory);
    }
}

