/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.AbstractFromConfigFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.RandomSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.MimicRecordingSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.SubListMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.Objects;

public final class SubListSelectorFactory<Solution_>
extends AbstractFromConfigFactory<Solution_, SubListSelectorConfig> {
    private static final int DEFAULT_MINIMUM_SUB_LIST_SIZE = 1;
    private static final int DEFAULT_MAXIMUM_SUB_LIST_SIZE = Integer.MAX_VALUE;

    private SubListSelectorFactory(SubListSelectorConfig config) {
        super(config);
    }

    public static <Solution_> SubListSelectorFactory<Solution_> create(SubListSelectorConfig subListSelectorConfig) {
        return new SubListSelectorFactory<Solution_>(subListSelectorConfig);
    }

    public SubListSelector<Solution_> buildSubListSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (((SubListSelectorConfig)this.config).getMimicSelectorRef() != null) {
            return this.buildMimicReplaying(configPolicy);
        }
        if (inheritedSelectionOrder != SelectionOrder.RANDOM) {
            throw new IllegalArgumentException("The subListSelector (%s) has an inheritedSelectionOrder(%s) which is not supported. SubListSelector only supports random selection order.".formatted(new Object[]{this.config, inheritedSelectionOrder}));
        }
        IterableValueSelector<Solution_> valueSelector = this.buildIterableValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, inheritedSelectionOrder);
        Integer minimumSubListSize = Objects.requireNonNullElse(((SubListSelectorConfig)this.config).getMinimumSubListSize(), 1);
        Integer maximumSubListSize = Objects.requireNonNullElse(((SubListSelectorConfig)this.config).getMaximumSubListSize(), Integer.MAX_VALUE);
        RandomSubListSelector<Solution_> baseSubListSelector = new RandomSubListSelector<Solution_>(entitySelector, valueSelector, minimumSubListSize, maximumSubListSize);
        SubListSelector<Solution_> subListSelector = this.applyNearbySelection(configPolicy, minimumCacheType, inheritedSelectionOrder, baseSubListSelector);
        subListSelector = this.applyMimicRecording(configPolicy, subListSelector);
        return subListSelector;
    }

    SubListSelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (((SubListSelectorConfig)this.config).getId() != null || ((SubListSelectorConfig)this.config).getMinimumSubListSize() != null || ((SubListSelectorConfig)this.config).getMaximumSubListSize() != null || ((SubListSelectorConfig)this.config).getValueSelectorConfig() != null || ((SubListSelectorConfig)this.config).getNearbySelectionConfig() != null) {
            throw new IllegalArgumentException("The subListSelectorConfig (%s) with mimicSelectorRef (%s) has another property that is not null.".formatted(this.config, ((SubListSelectorConfig)this.config).getMimicSelectorRef()));
        }
        SubListMimicRecorder<Solution_> subListMimicRecorder = configPolicy.getSubListMimicRecorder(((SubListSelectorConfig)this.config).getMimicSelectorRef());
        if (subListMimicRecorder == null) {
            throw new IllegalArgumentException("The subListSelectorConfig (%s) has a mimicSelectorRef (%s) for which no subListSelector with that id exists (in its solver phase).".formatted(this.config, ((SubListSelectorConfig)this.config).getMimicSelectorRef()));
        }
        return new MimicReplayingSubListSelector<Solution_>(subListMimicRecorder);
    }

    private SubListSelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, SubListSelector<Solution_> subListSelector) {
        String id = ((SubListSelectorConfig)this.config).getId();
        if (id != null) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("The subListSelectorConfig (%s) has an empty id (%s).".formatted(this.config, id));
            }
            MimicRecordingSubListSelector<Solution_> mimicRecordingSubListSelector = new MimicRecordingSubListSelector<Solution_>(subListSelector);
            configPolicy.addSubListMimicRecorder(id, mimicRecordingSubListSelector);
            subListSelector = mimicRecordingSubListSelector;
        }
        return subListSelector;
    }

    private SubListSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, RandomSubListSelector<Solution_> subListSelector) {
        NearbySelectionConfig nearbySelectionConfig = ((SubListSelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig == null) {
            return subListSelector;
        }
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((SubListSelectorConfig)this.config, configPolicy, minimumCacheType, resolvedSelectionOrder, subListSelector);
    }

    private IterableValueSelector<Solution_> buildIterableValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelectorConfig valueSelectorConfig;
        ValueSelectorConfig valueSelectorConfig2 = valueSelectorConfig = this.config != null ? ((SubListSelectorConfig)this.config).getValueSelectorConfig() : null;
        if (valueSelectorConfig == null) {
            valueSelectorConfig = new ValueSelectorConfig();
        }
        if (configPolicy.getSolutionDescriptor().hasBothBasicAndListVariables() && valueSelectorConfig.getVariableName() == null) {
            String variableName = entityDescriptor.getGenuineListVariableDescriptor().getVariableName();
            valueSelectorConfig.setVariableName(variableName);
        }
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        return (IterableValueSelector)valueSelector;
    }
}

